﻿using System;
using System.Configuration;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MDWS;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.TBIInstrumentVIAsrv;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_InstrumentSummaryNote : BaseTBIInstrumentPage
{
    #region Variable Declarations

    protected string _serviceToUse = Helpers.getCurrentServiceToUse(); //ConfigurationManager.AppSettings["TBIServiceToUse"].ToString();

    private string note;
    SURVEY survey;
    string rawScore = "N/A";
    string tScore = "N/A";
    string _surveyDate = DateTime.Today.ToString();
    string _notetype;
    bool Q1 = false, Q2 = false, Q3 = false, Q4 = false, Q5 = false, Q6 = false, Q7 = false, Q8 = false, Q9 = false, Q10 = false, Q11 = false;
    bool Q12 = false, Q13 = false, Q14 = false, Q15 = false, Q16 = false, Q17 = false, Q18 = false, Q19 = false, Q20 = false, Q21 = false, Q22 = false;
    private bool viewOnly = false;
    //VIAInstrumentsManager _tbiVIAInstrumentManager = new VIAInstrumentsManager();
    PatientManager pManager = new PatientManager();

    #endregion

    #region Private Enums

    private enum QuestionTypeEnum : int {
        RadioButtonsBased = 0,
        TexBased = 1,
        CheckBoxesBased = 2
    }

    #endregion

    #region Public Declarations

    public TBI_Instruments_InstrumentSummaryNote() {
        //Manager Save Notification Event Handler
        pManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e) {

        base.BaseTBIInstrumentPage_Load(sender, e);

        try {
            TBIServiceTO _tbiServiceTo;
            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;
        } catch (Exception _ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(_ex, "InstrumentSummaryNote.aspx", "100026", "SESSIONENDED");
            Response.Redirect("Warning.aspx?err=2");
        }

        if (!IsPostBack) {
            try {
                survey = Session["survey"] as SURVEY;
                if (_tbiInstrumentManager.TbiServiceTo != null) {
                    Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }
            } catch (Exception _ex2) {
                //Redirect to message that session is ended and need to log back in from CPRS.
                Exception _tbilogerror = HandleTBIException(_ex2, "InstrumentSummaryNote.aspx", "100026", "SESSIONENDED - no survey");
                Response.Redirect("Warning.aspx?err=2");
            }

            try {
                if (survey != null)
                {
                    using (StringWriter sw = new StringWriter())
                    {
                        switch (survey.STD_SURVEY_TYPE_ID)
                        {
                            case 2:
                                SetupEvalQuestionnaireNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "InstrumentEvaluationEntry.aspx";
                                break;
                            case 3:
                                SetupFollowupQuestionnaireNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "InstrumentFollowUpEntry.aspx";
                                break;
                            case 4:
                                rawScore = Session["rawScore"] as string;
                                tScore = Session["tScore"] as string;
                                SetupMpaiNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "InstrumentMpaiEntry.aspx";
                                break;
                            case 5:
                                SetupCarePlanNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "InstrumentCarePlanEntry.aspx";
                                break;
                            case 6:
                                // SRS
                                SetupSRSNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "SRS.aspx";
                                break;
                            case 7:
                                // MedRed L-Test
                                SetupMedRedLTestNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "MedRed_L-Test.aspx";
                                break;
                            case 8:
                                // MedRed - LCI v2
                                SetupMedRedLCIv2Note(survey, sw, out note);
                                CancelButton.PostBackUrl = "MedRed_LCI-v2.aspx";
                                break;
                            case 9:
                                // MedRed - Two Minute Walk
                                SetupMedRedTwoMinWalkTestNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "MedRedTwoMinuteWalk.aspx";
                                break;
                            case 10:
                                // Patients Global Impression of Change (PGIC) scale
                                SetupPGICNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PatientGlobalImpOfChange.aspx";
                                break;
                            case 11:
                                // Neurobehavioral Symptom Inventory form
                                SetupNSINote(survey, sw, out note);
                                CancelButton.PostBackUrl = "NeurobehavioralSymptomInventory.aspx";
                                break;
                            case 12:
                                // Disabilty Rating Scale
                                SetupDisabilityRatingScaleNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "DisabiltyRatingScale.aspx";
                                break;
                            case 13:
                                // QUEST
                                SetupQUESTNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "QUESTInstrument.aspx";
                                break;
                            case 14:
                                // Satisfaction With Life Scale
                                SetupSatisfactionWithLifeNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "SatisfactionWithLifeScale.aspx";
                                break;
                            case 15:
                                // Functional Mobility Assessment
                                SetupFunctionalMobilityAssessmentNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "FunctionalMobilityAssessment.aspx";
                                break;
                            case 16:
                                // BERG BALANCE SCALE
                                SetupBergBalanceScaleNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "BergBalanceScale.aspx";
                                break;
                            case 17:
                                // VA Low Vision Visual Functioning (VA LV VFQ 20) Survey
                                SetupVALowVisionNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "VALowVisionSurvey.aspx";
                                break;
                            case 18:
                                // PART-O Survey
                                SetupPART_ONote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PART-O.aspx";
                                break;
                            case 19:
                                // MPAI-4 Survey
                                SetupMPAI_4Note(survey, sw, out note);
                                CancelButton.PostBackUrl = "MayoPortlandAdaptabilityInventory4.aspx";
                                break;
                            case 20:
                                // JFK Coma Recovery Scale Survey
                                SetupJFKComaRecoveryScaleNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "JFKComaRecoveryScale.aspx";
                                break;
                            case 21:
                                // Oswestry Low Back Pain Disability Questionnaire
                                SetupOswestryLowBackPainDisabilityNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "OswestryLBDQ.aspx";
                                break;
                            case 22:
                                // Timed Up and Go Survey
                                SetupTimedUpAndGoNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "TimedUpAndGo.aspx";
                                break;
                            case 23:
                                // Generalized Anxiety Disorder Scale Survey
                                SetupGeneralizedAnxietyDisorderScaleNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "GAD-7.aspx";
                                break;
                            case 24:
                                // Post Traumatic Stress Disorder (PTSD) CheckList - Civilian Version Survey
                                SetupPCLCNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PCL-C.aspx";
                                break;
                            case 25:
                                // Patient Health Questionnaire - 9 Survey
                                SetupPHQ9Note(survey, sw, out note);
                                CancelButton.PostBackUrl = "PHQ-9.aspx";
                                break;
                            case 26:
                                // Insomnia Severity Index Survey
                                SetupISINote(survey, sw, out note);
                                CancelButton.PostBackUrl = "InsomniaSeverityIndex.aspx";
                                break;
                            case 27:
                                // Pain Outcomes Questionnaire VA Long Form - Intake (POQI) Survey 
                                SetupPOQINote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PainOutcomes_Intake.aspx";
                                break;
                            case 28:
                                // Pain Outcomes Questionnaire VA Long Form - Discharge (POQD) Survey 
                                SetupPOQDNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PainOutcomes_Discharge.aspx";
                                break;
                            case 29:
                                // Pain Outcomes Questionnaire VA Long Form - Followup (POQF) Survey 
                                SetupPOQFNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "PainOutcomes_Followup.aspx";
                                break;
                            case 31:
                                // World Health Organization Disability Assessment Schedule 2.0 - Interview (WHODAS-I) Survey 
                                SetupWHODASINote(survey, sw, out note);
                                CancelButton.PostBackUrl = "Whodas-i.aspx";
                                break;
                            case 32:
                                // World Health Organization Disability Assessment Schedule 2.0 - Interview (WHODAS-P) Survey 
                                SetupWHODASPNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "Whodas-p.aspx";
                                break;
                            case 33:
                                // World Health Organization Disability Assessment Schedule 2.0 - Interview (WHODAS-S) Survey 
                                SetupWHODASSNote(survey, sw, out note);
                                CancelButton.PostBackUrl = "Whodas-s.aspx";
                                break;
                        	case 34:
                            	// Optimal
                            	SetupOptimalNote(survey, sw, out note);
                            	CancelButton.PostBackUrl = "Optimal.aspx";
                            	break;
                        	case 35:
                            	// Optimal
                            	SetupOptimalFollowUpNote(survey, sw, out note);
                            	CancelButton.PostBackUrl = "OptimalFollowUp.aspx";
                            	break;
                        	case 36:
                            	// Rehab FollowUp
                            	SetupRehabFollowUpNote(survey, sw, out note);
                            	CancelButton.PostBackUrl = "RehabFollowUp.aspx";
                            	break;
                            case 37:
                                // Pain Interference Short Form 6a
                                rawScore = Session["rawScore"] as string;
                                tScore = Session["tScore"] as string;
                                SetupPainInterferenceShortForm6a(survey, sw, out note);
                                CancelButton.PostBackUrl = "PainInterferenceShortForm6a.aspx";
                                break;
                            case 38:
                                // Pain Interference Short Form 6a
                                rawScore = Session["rawScore"] as string;
                                SetupPhysicalFunctionwMobilityAid(survey, sw, out note);
                                CancelButton.PostBackUrl = "PhysicalFunctionwMobilityAid.aspx";
                                break;
                            case 39:
                                // Pain Interference Short Form 6a
                                rawScore = Session["rawScore"] as string;
                                SetupUpperExtremityShortForm7a(survey, sw, out note);
                                CancelButton.PostBackUrl = "UpperExtremityShortForm7a.aspx";
                                break;
                            default:
                                break;
                        }
                    }
                }

                ViewState["Note"] = note;
            } 
            catch (Exception _ex3) 
            {
                Exception _tbilogerror = HandleTBIException(_ex3, "InstrumentSummaryNote.aspx", "100026", "Page_load - STD_SURVEY_TYPE_ID");
            }
        }

        if (_tbiInstrumentManager.TbiServiceTo == null) {
            //TODO post error
        } else {
            LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
            LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
        }

        try {
            if (Session["ViewOnly"] != null)
                viewOnly = Convert.ToBoolean(Session["ViewOnly"]);
        } catch (Exception _ex) {
            //Display error message to user
            Exception _tbilogerror = HandleTBIException(_ex, "InstrumentSummaryNote.aspx", "100026", "SESSIONENDED");
            Response.Redirect("Warning.aspx?err=7");
        }

        if (viewOnly) {
            Label8.Visible = false; //Instructions
            CancelButton.Visible = false;
            SubmitNoteButton.Text = "Back";
            SubmitNoteButton.ToolTip = "Back";
        }
    }

    /// <summary>
    /// Submit note to service.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void SubmitNote_Click(object sender, EventArgs e) {
        try {
            if (viewOnly) {
                Session.Remove("ViewOnly");
                Session.Remove("ConfirmedSSN");

                Response.Redirect("PatientInstrumentsMain.aspx", false);

                //if (Session["BypassMDWS"] == null) {
                //    Response.Redirect("PatientInstrumentsMain.aspx", false);
                //} else {
                //    Response.Redirect("PatientInstrumentsNoMDWS.aspx", false);
                //}
            } else {

                Logging.WriteLogToFile("Submitting Note");
                SubmitNoteButton.Enabled = true;
                TBIServiceTO _tbiServiceTO = GetTBIServiceToFromSession();
                TBIInstrumentsManager _tbiInstrumentManager = new TBIInstrumentsManager();

                AddtoSessionTBIServiceTo(_tbiServiceTO);

                _tbiServiceTO.NoteText = ViewState["Note"] as string;

                if (_tbiServiceTO != null) {

                    // 2 paths from here - MDWS - VIA
                    if (getCurrentServiceToUse() == "VIA")
                    {
                        #region VIA
                        Logging.WriteLogToFile("VIA submission-Text: " + _tbiServiceTO.NoteText);

                        // VIA

                        _tbiInstrumentManager.LoadTBI_VIAService(_tbiServiceTO);

                        noteResultTO _result = null;
                        _result = _tbiInstrumentManager.writeNoteWithVIA(_tbiServiceTO);

                        if (_result.fault == null) {
                            survey = Session["survey"] as SURVEY;
                            if (survey != null)
                            {
                                survey.SetAsChangeTrackingRoot();
                                survey.SURVEY_STATUS = "completed";

                                SURVEY_NOTE note = new SURVEY_NOTE();

                                note.NOTES_TEXT = _tbiServiceTO.NoteText;
                                note.ENTRY_DATE = DateTime.Today;
                                note.NOTE_DATE = DateTime.Today;
                                note.STD_INSTITUTION_ID = 1000001;
                                survey.SURVEY_NOTEs.Add(note);

                                _tbiInstrumentManager.Update(survey);
                                SubmitNoteButton.Enabled = false;
                            }

                            Session.Remove("survey");

                            Logging.WriteLogToFile("Completed note submission and writing survey data");
                            string script = "<script language=\"javascript\"  type=\"text/javascript\">window.close();</script>";
                            ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
                        } else {

                            Logging.WriteLogToFile("Error submitting note: " + _result.fault.message);

                            SurveyNoteError.Text = "Error: " + _result.fault.message;
                            ErrorPanel.Visible = true;
                            //ButtonsPanel.Visible = false;
                            //SurveyNoteHTML.Visible = false;
                        }
                        #endregion

                    }
                    else
                    {
                        #region MDWS
                        Logging.WriteLogToFile("MDWS submission-Text: " + _tbiServiceTO.NoteText);

                        // MDWS
                        NoteResultTO _result = null;

                        _tbiInstrumentManager.LoadTbiService(_tbiServiceTO);

                        if (Session["BypassMDWS"] == null) {
                            _result = _tbiInstrumentManager.writeNote(_tbiServiceTO);
                        } else {
                            _result = new NoteResultTO();
                        }

                        if (_result.fault == null) {
                            survey = Session["survey"] as SURVEY;
                            if (survey != null)
                            {
                                survey.SetAsChangeTrackingRoot();
                                survey.SURVEY_STATUS = "completed";

                                SURVEY_NOTE note = new SURVEY_NOTE();

                                note.NOTES_TEXT = _tbiServiceTO.NoteText;
                                note.ENTRY_DATE = DateTime.Today;
                                note.NOTE_DATE = DateTime.Today;
                                note.STD_INSTITUTION_ID = 1000001;
                                survey.SURVEY_NOTEs.Add(note);

                                _tbiInstrumentManager.Update(survey);
                                //SubmitNoteButton.Enabled = false;
                            }
                            Session.Remove("survey");

                            Logging.WriteLogToFile("Completed note submission and writing survey data");

                            string script = "<script language=\"javascript\"  type=\"text/javascript\">window.open('','_self','');window.close();</script>";
                            ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
                        }
                        else
                        {
                            Logging.WriteLogToFile("Error submitting note: " + _result.fault.message);
                            SurveyNoteError.Text = "Error: " + _result.fault.message;
                            ErrorPanel.Visible = true;
                            //ButtonsPanel.Visible = false;
                            //SurveyNoteHTML.Visible = false;
                        }

                        #endregion
                    }
                }
            }

        } catch (Exception ex) {
            Exception _mssrlogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SubmitNote_Click()");
        }
    }

    #endregion

    #region Private Methods

    private void SetupEvalQuestionnaireNote(SURVEY evalSurvey, StringWriter writer, out string evalNote) {
        string tempOutString = "";
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbEvalNote = new StringBuilder();

        try
        {
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(functionalMobilitySurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(evalSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbEvalNote.Append(titleLine);
                    sbEvalNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbEvalNote.AppendLine();
            }

            #endregion
            var questions = evalSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            //foreach (var result in evalSurvey.SURVEY_RESULTs.OrderBy(c => c.STD_QUESTION_CHOICE_ID).ToList())


            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                //radio-button based questions         
                //switch (question.Key.QUESTION_NUMBER)
                switch (question.Key.QUESTION_NUMBER) {
                    case "A":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5-A":
                    case "5-B":
                    case "5-C":
                    case "5-D":
                    case "5-D-1":
                    case "5-D-1-a":
                    case "5-D-2":
                    case "5-D-3":
                    case "5-D-4":
                    case "5-E":
                    case "6":
                    case "6-A":
                    case "7":
                    case "7-A":
                    case "8":
                    case "8-A":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "12-A":
                    case "13":
                    case "14":
                    case "15":
                    case "16-A":
                    case "16-B":
                    case "16-C":
                    case "16-D":
                    case "16-E":
                    case "16-F":
                    case "16-G":
                    case "16-H":
                    case "16-I":
                    case "16-J":
                    case "16-K":
                    case "16-L":
                    case "16-M":
                    case "16-N":
                    case "16-O":
                    case "16-P":
                    case "16-Q":
                    case "16-R":
                    case "16-S":
                    case "16-T":
                    case "16-U":
                    case "16-V":
                    case "17":
                    case "18":
                    case "18-B":
                    case "19":
                    case "21-A":
                    case "21-B":
                    case "23":
                    case "24":
                    case "25":
                    case "26":
                    case "27":
                    case "28":
                    case "29":
                    case "29-A":
                    case "29-A-1-a":
                    case "29-A-1-b":
                    case "29-A-1-c":
                    case "29-A-1-d":
                    case "29-A-1-e":
                    case "29-A-1-f":
                    case "29-A-1-f-1":
                    case "29-A-1-g":
                    case "29-A-1-i":
                    case "29-A-1-j":
                    case "29-D":
                    case "29-D-1":
                    case "29-E":
                    case "29-F":
                    case "29-G":
                    case "29-H":
                    case "29-A-2":
                    case "29-A-2-a":

                        if (question.Key.QUESTION_NUMBER == "5-A") {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("Cause of Injury:");
                            htmlWriter.WriteBreak();

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbEvalNote.AppendLine("Cause of Injury:");
                            sbEvalNote.AppendLine();
                        }
                        //SURVEY_RESULT radioResult = evalSurvey.SURVEY_RESULTs.Where(c => c.STD_QUESTION_CHOICE.STD_QUESTION_ID == question.Key.ID).FirstOrDefault();
                        if (question.Key.QUESTION_NUMBER == "16-A") {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("Symptoms");
                            htmlWriter.WriteBreak();


                            htmlWriter.WriteLine("15. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):");
                            htmlWriter.WriteBreak();

                            htmlWriter.Write("&nbsp;&nbsp;<b>None</b> 0 - Rarely if ever present not a problem at all.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Mild</b> 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Moderate</b> 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Severe</b> 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.");
                            htmlWriter.WriteBreak();
                            htmlWriter.WriteLine("&nbsp;&nbsp;<b>Very Severe</b> 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.");

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbEvalNote.AppendLine("Symptoms");
                            sbEvalNote.AppendLine();
                            sbEvalNote.AppendLine("\t" + "15. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):");
                            sbEvalNote.AppendLine();
                            sbEvalNote.AppendLine("\t" + "None 0 - Rarely if ever present not a problem at all.");
                            sbEvalNote.AppendLine("\t" + "Mild 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.");
                            sbEvalNote.AppendLine("\t" + "Moderate 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.");
                            sbEvalNote.AppendLine("\t" + "Severe 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.");
                            sbEvalNote.AppendLine("\t" + "Very Severe 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.");
                            sbEvalNote.AppendLine();
                        }
                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(getCTBIEQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER));
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbEvalNote.Append(getCTBIEQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.StartsWith("16-") == false)
                                sbEvalNote.AppendLine();
                            sbEvalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbEvalNote.AppendLine();

                        }
                        if (question.Key.SkipSpace) {

                            sbEvalNote.AppendLine();

                        }
                        break;

                    //textbox-based questions
                    case "4-A-1":
                    case "4-A-2":
                    case "4-B-1":
                    case "4-B-2":
                    case "4-C-1":
                    case "4-C-2":
                    case "17-A":
                    case "18-C":
                    case "20":
                    case "21":
                    case "21-C":
                    case "22":
                    case "28-A":
                    case "29-A-1-f-2":
                    case "29-A-1-h":
                    case "29-A-1-e-1":
                    case "29-I-1":
                    case "29-B-1":
                    case "30":

                        //SURVEY_RESULT textResult = evalSurvey.SURVEY_RESULTs.Where(c => c.STD_QUESTION_CHOICE.STD_QUESTION_ID == question.Key.ID).FirstOrDefault();

                        foreach (var answer in question)
                        {
                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write(getCTBIEQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER));
                                htmlWriter.Write("&nbsp;");
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                                {
                                    htmlWriter.Write(answer.RESULT_TEXT + " ");
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbEvalNote.Append(getCTBIEQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.StartsWith("16-") == false)
                                    sbEvalNote.AppendLine();

                                if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                                {
                                    sbEvalNote.Append("\t" + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbEvalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                sbEvalNote.AppendLine();

                            }

                            if (question.Key.SkipSpace)
                            {

                                sbEvalNote.AppendLine();

                            }
                        }
                        break;

                    //listbox-based questions
                    case "5-D-5":
                    case "18-A":
                    case "23-A":
                    case "29-A-1":
                    case "29-A-1-j-1":
                    case "29-B":
                    case "29-C":
                    case "29-I":
                        //List<SURVEY_RESULT> checkResults = evalSurvey.SURVEY_RESULTs.Where(c => c.STD_QUESTION_CHOICE.STD_QUESTION_ID == question.Key.ID).ToList();


                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(getCTBIEQuestionNumber(question.Key.QUESTION_NUMBER));
                        htmlWriter.Write("&nbsp");
                        htmlWriter.Write(question.Key.QUESTION_TEXT);

                        htmlWriter.RenderEndTag();
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        sbEvalNote.Append(getCTBIEQuestionNumber(question.Key.QUESTION_NUMBER) + " " + question.Key.QUESTION_TEXT);
                        sbEvalNote.AppendLine();
                        //sbEvalNote.AppendLine();

                        foreach (var answer in question) {
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            htmlWriter.WriteBreak();

                            sbEvalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbEvalNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {

                            sbEvalNote.AppendLine();

                        }

                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        break;

                    default:

                        break;

                }

            }
            //table
            htmlWriter.RenderEndTag();
            //center
            htmlWriter.RenderEndTag();
            //body
            htmlWriter.RenderEndTag();
            //html
            htmlWriter.RenderEndTag();

            SurveyNoteHTML.Text = writer.ToString();


            //evalNote = sbEvalNote.ToString();
            tempOutString = sbEvalNote.ToString();
        } catch (Exception _ex) {
            Exception _tbilogerror = HandleTBIException(_ex, "InstrumentSummaryNote.aspx", "100026", "SetupEvalQuestionnaireNote()");
        }
        finally {
            if (sbEvalNote != null) {
                if (sbEvalNote.ToString().Length > 0) {
                    //evalNote = sbEvalNote.ToString();
                    tempOutString = sbEvalNote.ToString();
                }
            }
        }
        evalNote = tempOutString;
    }

    private void SetupFollowupQuestionnaireNote(SURVEY followupSurvey, StringWriter writer, out string followupNote) {
        string tempOutString = "";
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbFollowUpNote = new StringBuilder();

        try {

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(functionalMobilitySurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(followupSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbFollowUpNote.Append(titleLine);
                    sbFollowUpNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbFollowUpNote.AppendLine();
            }

            #endregion

            var questions = followupSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });


            //foreach (var result in evalSurvey.SURVEY_RESULTs.OrderBy(c => c.STD_QUESTION_CHOICE_ID).ToList())
            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {
                    //text-based questions   
                    case "A"://TextBoxChiefComplaint
                    case "B"://TextBoxHistoryPresentIllness
                    case "4-A":
                    case "4-B": //tbxYearOfRecentHeadInjury
                    case "12-A":
                    case "15": //tbxAdditionalComments.Text = _surveyResult.RESULT_TEXT; //
                    case "16":
                    case "17":
                    case "18":
                    case "19-A-1":
                    case "21":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbFollowUpNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.StartsWith("11-") == false)
                                sbFollowUpNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbFollowUpNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbFollowUpNote.AppendLine();
                            //sbFollowUpNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {

                            sbFollowUpNote.AppendLine();

                        }

                        break;

                    //listbox-based questions
                    case "5-D-5":
                    case "13-A":

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(question.Key.QUESTION_NUMBER);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.Write(question.Key.QUESTION_TEXT);

                        htmlWriter.RenderEndTag();
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        sbFollowUpNote.Append(question.Key.QUESTION_NUMBER + " " + question.Key.QUESTION_TEXT);
                        sbFollowUpNote.AppendLine();

                        foreach (var answer in question) {
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            htmlWriter.WriteBreak();

                            sbFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbFollowUpNote.AppendLine();
                        }
                        //sbFollowUpNote.AppendLine();

                        if (question.Key.SkipSpace) {

                            sbFollowUpNote.AppendLine();

                        }
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        break;

                    //radio-button based questions
                    case "1":
                    case "2":
                    case "2-A":
                    case "3":
                    case "4":
                    case "5":
                    case "5-A":
                    case "5-B":
                    case "5-C":
                    case "5-D":
                    case "5-D-1":
                    case "5-D-1-A":
                    case "5-D-2":
                    case "5-D-3":
                    case "5-D-4":
                    case "5-E":
                    case "6":
                    case "6-A":
                    case "7":
                    case "7-A":
                    case "8":
                    case "8-A":
                    case "9":
                    case "10":
                    case "10-A":
                    case "11-A":
                    case "11-B":
                    case "11-C":
                    case "11-D":
                    case "11-E":
                    case "11-F":
                    case "11-G":
                    case "11-H":
                    case "11-I":
                    case "11-J":
                    case "11-K":
                    case "11-L":
                    case "11-M":
                    case "11-N":
                    case "11-O":
                    case "11-P":
                    case "11-Q":
                    case "11-R":
                    case "11-S":
                    case "11-T":
                    case "11-U":
                    case "11-V":
                    case "12":
                    case "13":
                    case "13-B":
                    case "14":
                    case "19":
                    case "19-A":
                    case "20":

                        if (question.Key.QUESTION_NUMBER == "11-A") {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("Symptoms");
                            htmlWriter.WriteBreak();

                            htmlWriter.Write("&nbsp;&nbsp;11. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>None</b> 0 - Rarely if ever present not a problem at all.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Mild</b> 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Moderate</b> 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Severe</b> 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.");
                            htmlWriter.WriteBreak();
                            htmlWriter.Write("&nbsp;&nbsp;<b>Very Severe</b> 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.");

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbFollowUpNote.AppendLine("Symptoms");
                            sbFollowUpNote.AppendLine();
                            sbFollowUpNote.AppendLine("\t" + "11. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):");
                            sbFollowUpNote.AppendLine();
                            sbFollowUpNote.AppendLine("\t" + "None 0 - Rarely if ever present not a problem at all.");
                            sbFollowUpNote.AppendLine("\t" + "Mild 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.");
                            sbFollowUpNote.AppendLine("\t" + "Moderate 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.");
                            sbFollowUpNote.AppendLine("\t" + "Severe 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.");
                            sbFollowUpNote.AppendLine("\t" + "Very Severe 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.");
                            sbFollowUpNote.AppendLine();
                        }

                        if (question.Key.QUESTION_NUMBER == "5-A") {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("Cause of Injury:");
                            htmlWriter.WriteBreak();

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbFollowUpNote.AppendLine("Cause of Injury:");
                            sbFollowUpNote.AppendLine();
                        }


                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();


                            sbFollowUpNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.StartsWith("11-") == false)
                                sbFollowUpNote.AppendLine();
                            sbFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbFollowUpNote.AppendLine();
                            //sbFollowUpNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {

                            sbFollowUpNote.AppendLine();

                        }
                        break;
                    default:

                        //anything out of the ordinary 

                        break;

                }

            }
            htmlWriter.RenderEndTag();
            //center
            htmlWriter.RenderEndTag();
            //body
            htmlWriter.RenderEndTag();
            //html
            htmlWriter.RenderEndTag();

            SurveyNoteHTML.Text = writer.ToString();

            followupNote = sbFollowUpNote.ToString();
        } catch (Exception _ex) {
            Exception _tbilogerror = HandleTBIException(_ex, "InstrumentSummaryNote.aspx", "100026", "SetupFollowupQuestionnaireNote()");
        }
        finally {
            if (sbFollowUpNote != null) {
                if (sbFollowUpNote.ToString().Length > 0) {
                    //followupNote = sbFollowUpNote.ToString();
                    tempOutString = sbFollowUpNote.ToString();
                }
            }
        }
        followupNote = tempOutString;
    }

    private void SetupMpaiNote(SURVEY mpaiSurvey, StringWriter writer, out string mpaiNote) {
        string tempOutString = "";
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbMpaiNote = new StringBuilder();

        try {
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            //Render instrument title
            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(mpaiSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(mpaiSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbMpaiNote.Append(titleLine);
                    sbMpaiNote.AppendLine();

                    if (titleLine.Contains("PhD")) {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Small);
                        htmlWriter.Write(titleLine);
                        htmlWriter.RenderEndTag();//Small
                    } else {
                        htmlWriter.Write(titleLine);
                    }
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbMpaiNote.AppendLine();
            }

            // Move date / scores to the top of the list
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(System.DateTime.Now.ToShortDateString());
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbMpaiNote.Append("Survey Date:");
            sbMpaiNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            sbMpaiNote.AppendLine();

            //Add Raw Score
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Raw Score");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(rawScore);
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbMpaiNote.Append("Raw Score:");
            sbMpaiNote.Append("\t" + rawScore);
            sbMpaiNote.AppendLine();


            //Add T Score
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("T Score");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(tScore);
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbMpaiNote.Append("T Score:");
            sbMpaiNote.Append("\t" + tScore);
            sbMpaiNote.AppendLine();

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.Write("&nbsp;");
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbMpaiNote.AppendLine();

            //Render questions and responses
            var questions = mpaiSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            int _answerCount = 0;
            int _tempCount = 0;
            _answerCount = Convert.ToInt32(Session["MPAIAnswerCount"].ToString());
            _tempCount = _answerCount;
            string strAnswer01 = String.Empty;
            string strQuestion7BR = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                //if (_answerCount > 0)
                //{
                    switch (question.Key.QUESTION_NUMBER)
                    {
                        //text-based questions   
                        case "C1"://TextBoxC1
                        case "C2"://TextBoxC2
                        case "C3"://TextBoxC3
                        case "C4"://TextBoxC4
                        case "C5"://TextBoxC5
                        case "C6"://TextBoxC6
                        case "C7A"://TextBoxC7A
                        case "C7B"://TextBoxC7B
                        case "C8"://TextBoxC8
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (!question.Key.QUESTION_NUMBER.StartsWith("C"))
                                {
                                    sbMpaiNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                    sbMpaiNote.AppendLine();
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                    htmlWriter.Write("&nbsp;");
                                }
                                else
                                {
                                    sbMpaiNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ": - ");
                                }
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                                {
                                    htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();


                                if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                                {
                                    sbMpaiNote.Append("\t" + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbMpaiNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                sbMpaiNote.AppendLine();
                               // _answerCount--;
                            }
                            if (question.Key.SkipSpace)
                            {
                                sbMpaiNote.AppendLine();
                            }

                            break;

                        //radio-button based questions

                        case "-1"://LabelNoteType
                        case "0":
                        case "1":
                        case "2":
                        case "3":
                        case "4":
                        case "5":
                        case "6":
                        case "7A":
                        case "7B":
                        case "8":

                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (question.Key.QUESTION_NUMBER == "-1")
                                {
                                    _notetype = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                                }

                                if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                                {
                                    strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - ";
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                    htmlWriter.Write(" - ");
                                }
                                else
                                {
                                    strNoteQuestion = String.Empty;
                                }
                                string s = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                                if (s.Substring(0, 2) == "0 " || s.Substring(0, 2) == "1 " || s.Substring(0, 2) == "2 " || s.Substring(0, 2) == "3 " || s.Substring(0, 2) == "4 ")
                                {
                                    s = s.Substring(2, s.Length - 2);
                                }

                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (question.Key.QUESTION_NUMBER == "7B")
                                {
                                    try
                                    {
                                        int _mpaisurveycount = 0;

                                        _mpaisurveycount = _tbiInstrumentManager.GetChoicesByQuestionNumber("7B-R", mpaiSurvey.SURVEYS_ID).Count;
                                        if (_mpaisurveycount > 0)
                                        {
                                            strQuestion7BR = _tbiInstrumentManager.GetChoicesByQuestionNumber("7B-R", mpaiSurvey.SURVEYS_ID).FirstOrDefault().STD_QUESTION_CHOICE.CHOICE_NAME;
                                        }
                                        //}
                                        if (!String.IsNullOrEmpty(strQuestion7BR))
                                        {
                                            htmlWriter.Write("Primary Desired Role: " + strQuestion7BR);
                                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Br);
                                        }
                                    }
                                    catch (Exception ex)
                                    {
                                        //Ignore error
                                        Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "variable set is strQuestion7BR");
                                    }
                                }
                                htmlWriter.Write(s);

                                if (question.Key.QUESTION_NUMBER == "0")
                                {
                                    try
                                    {
                                        if (_tbiInstrumentManager != null && mpaiSurvey != null)
                                        {
                                            int _mpaisurveycount2 = 0;
                                            _mpaisurveycount2 = _tbiInstrumentManager.GetChoicesByQuestionNumber("0-1", mpaiSurvey.SURVEYS_ID).Count;
                                            if (_mpaisurveycount2 > 0)
                                            {
                                                strAnswer01 = _tbiInstrumentManager.GetChoicesByQuestionNumber("0-1", mpaiSurvey.SURVEYS_ID).FirstOrDefault().RESULT_TEXT;
                                                if (!String.IsNullOrEmpty(strAnswer01))
                                                {
                                                    htmlWriter.Write("&nbsp;-&nbsp;" + strAnswer01);
                                                }
                                            }
                                        }
                                        //}
                                    }
                                    catch (Exception _ex)
                                    {
                                        //Ignore error
                                        Exception _tbilogerror = HandleTBIException(_ex, "InstrumentSummaryNote.aspx", "100026", "variable set is strQuestion0-1");
                                    }
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                                {
                                    sbMpaiNote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                    sbMpaiNote.AppendLine();
                                }
                                else
                                {
                                    sbMpaiNote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ": - ");
                                }

                                if ((question.Key.QUESTION_NUMBER == "0") && (!String.IsNullOrEmpty(strAnswer01)))
                                {
                                    sbMpaiNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " - " + strAnswer01);
                                }
                                else if ((question.Key.QUESTION_NUMBER == "7B") && (!String.IsNullOrEmpty(strQuestion7BR)))
                                {
                                    sbMpaiNote.Append("\t" + "Primary Desired Role: " + strQuestion7BR);
                                    sbMpaiNote.AppendLine();
                                    sbMpaiNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                else
                                {

                                    sbMpaiNote.Append("\t" + s);
                                }
                                sbMpaiNote.AppendLine();
                               // _answerCount--;
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbMpaiNote.AppendLine();
                            }
                            break;
                        default:
                            //anything out of the ordinary 
                            break;
                    }
               // }
            }

            htmlWriter.RenderEndTag();
            //center
            htmlWriter.RenderEndTag();
            //body
            htmlWriter.RenderEndTag();
            //html
            htmlWriter.RenderEndTag();

            SurveyNoteHTML.Text = writer.ToString();

            //insert instance of care
            if (_notetype != "Initial")
            {
                var mpaiInstanceOfCareNote = SqlProvider.ExecuteScalar("RegistryConnectionString", "[TBI].[SP_InsertInstanceOfCareNote]", new object[] { mpaiSurvey.patient_ICN, mpaiSurvey.SURVEYS_ID, _notetype, _surveyDate, Session["InstanceNumber"].ToString() });
            }

            tempOutString = sbMpaiNote.ToString();
        } catch (Exception ex2) {
            Exception _tbilogerror = HandleTBIException(ex2, "InstrumentSummaryNote.aspx", "100026", "SESSIONENDED");
        }
        finally {
            if (sbMpaiNote != null) {
                if (sbMpaiNote.ToString().Length > 0) {
                    //mpaiNote = sbMpaiNote.ToString();
                    tempOutString = sbMpaiNote.ToString();
                }
            }
        }
        mpaiNote = tempOutString;
    }

    private void SetupCarePlanNote(SURVEY carePlanSurvey, StringWriter writer, out string carePlanNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbCarePlanNote = new StringBuilder();
        string tempOutString = "";

        try {
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            //Render instrument title
            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(carePlanSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(carePlanSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbCarePlanNote.Append(titleLine);
                    sbCarePlanNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbCarePlanNote.AppendLine();
            }

            //Render questions and responses
            var questions = carePlanSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {
                    //text-based questions   
                    case "1":
                    case "2-1":
                    case "3-1":
                    case "5":
                    case "8":
                    case "9":
                    case "11":
                    case "12":
                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!question.Key.QUESTION_NUMBER.Equals("2-1") && !question.Key.QUESTION_NUMBER.Equals("3-1")) {
                                if (!question.Key.QUESTION_NUMBER.Equals("11")) {
                                    sbCarePlanNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                    sbCarePlanNote.AppendLine();
                                } else {
                                    sbCarePlanNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                }

                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            } else {
                                sbCarePlanNote.Append("Additional Comments:");
                                htmlWriter.Write("Additional Comments");
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();


                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbCarePlanNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbCarePlanNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbCarePlanNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbCarePlanNote.AppendLine();
                        }

                        break;

                    //radio-button based questions
                    case "-1"://LabelNoteType
                    case "0":
                    case "7":
                    case "I7-1":
                    case "I7-2":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "I7-1" && question.Key.QUESTION_NUMBER != "I7-2") {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " ";
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            } else {
                                strNoteQuestion = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "I7-1" && question.Key.QUESTION_NUMBER != "I7-2") {
                                sbCarePlanNote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                sbCarePlanNote.AppendLine();
                            } else {
                                sbCarePlanNote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            }

                            sbCarePlanNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);

                            sbCarePlanNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbCarePlanNote.AppendLine();
                        }
                        break;

                    //listbox-based questions
                    case "2":
                    case "3":
                    case "4":
                    case "6":
                    case "10":

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(question.Key.QUESTION_NUMBER);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.Write(question.Key.QUESTION_TEXT);

                        htmlWriter.RenderEndTag();
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        sbCarePlanNote.Append(question.Key.QUESTION_NUMBER + " " + question.Key.QUESTION_TEXT);
                        sbCarePlanNote.AppendLine();

                        foreach (var answer in question) {
                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);
                            htmlWriter.WriteBreak();

                            sbCarePlanNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);
                            sbCarePlanNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {

                            sbCarePlanNote.AppendLine();

                        }
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        break;
                    default:

                        //anything out of the ordinary 

                        break;

                }

            }

            //table
            htmlWriter.RenderEndTag();
            //center
            htmlWriter.RenderEndTag();
            //body
            htmlWriter.RenderEndTag();
            //html
            htmlWriter.RenderEndTag();

            SurveyNoteHTML.Text = writer.ToString();

            //carePlanNote = sbCarePlanNote.ToString();
            tempOutString = sbCarePlanNote.ToString();
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupCarePlanNote()");
        }
        finally {
            if (sbCarePlanNote != null) {
                if (sbCarePlanNote.ToString().Length > 0) {
                    //carePlanNote = sbCarePlanNote.ToString();
                    tempOutString = sbCarePlanNote.ToString();
                }
            }
        }
        carePlanNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for MedRed L-Test Instrument
    /// </summary>
    /// <param name="medRedLTestSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="medRedLTestNote"></param>
    private void SetupMedRedLTestNote(SURVEY medRedLTestSurvey, StringWriter writer, out string medRedLTestNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbMedRedLTestNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(medRedLTestSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(medRedLTestSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbMedRedLTestNote.Append(titleLine);
                    sbMedRedLTestNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbMedRedLTestNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = medRedLTestSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {
                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":
                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMedRedLTestNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMedRedLTestNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbMedRedLTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbMedRedLTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbMedRedLTestNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbMedRedLTestNote.AppendLine();
                        }

                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "10":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == answer.RESULT_TEXT.ToLower()) {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMedRedLTestNote.Append(strNoteQuestion);
                            sbMedRedLTestNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == answer.RESULT_TEXT.ToLower()) {
                                sbMedRedLTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            } else {
                                sbMedRedLTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + strDetail);
                            }
                            sbMedRedLTestNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbMedRedLTestNote.AppendLine();
                        }
                        break;

                    #endregion

                    #region text-based questions

                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "11":
                    case "12":
                    case "13":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            sbMedRedLTestNote.Append(strNoteQuestion);
                            sbMedRedLTestNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbMedRedLTestNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbMedRedLTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMedRedLTestNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbMedRedLTestNote.AppendLine();
                        }

                        break;

                    #endregion

                    //listbox questions

                    // anything else
                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupMedRedLTestNote()");
        }
        finally {
            if (sbMedRedLTestNote != null) {
                if (sbMedRedLTestNote.ToString().Length > 0) {
                    //carePlanNote = sbCarePlanNote.ToString();
                    tempOutString = sbMedRedLTestNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        medRedLTestNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for MedRed LCI v2 Instrument
    /// </summary>
    /// <param name="medRedLCIv2Survey"></param>
    /// <param name="writer"></param>
    /// <param name="medRedLCIv2Note"></param>
    private void SetupMedRedLCIv2Note(SURVEY medRedLCIv2Survey, StringWriter writer, out string medRedLCIv2Note) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbMedRedLCIv2Note = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(medRedLCIv2Survey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(medRedLCIv2Survey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbMedRedLCIv2Note.Append(titleLine);
                    sbMedRedLCIv2Note.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbMedRedLCIv2Note.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = medRedLCIv2Survey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {
                    #region Radio Button List questions

                    #region text-based questions

                    case "15":
                    case "16":
                    case "17":
                    case "18":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                            strNoteQuestion = getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            sbMedRedLCIv2Note.Append(strNoteQuestion);
                            sbMedRedLCIv2Note.AppendLine();

                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbMedRedLCIv2Note.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbMedRedLCIv2Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMedRedLCIv2Note.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbMedRedLCIv2Note.AppendLine();
                        }
                      
                        break;

                    #endregion
                    //radio-button based questions
                    case "DX":
                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMedRedLCIv2Note.Append(getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMedRedLCIv2Note.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbMedRedLCIv2Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbMedRedLCIv2Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbMedRedLCIv2Note.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbMedRedLCIv2Note.AppendLine();
                        }

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.Write("<br />");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMedRedLCIv2Note.Append(strNoteQuestion);
                            sbMedRedLCIv2Note.AppendLine();

                            sbMedRedLCIv2Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbMedRedLCIv2Note.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "7" || answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "14")
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write("<br />");
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                        }
                        }

                        if (question.Key.SkipSpace) {
                            sbMedRedLCIv2Note.AppendLine();
                        }

                     

                        break;

                    #endregion

                   

                    //listbox questions

                    // anything else
                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupMedRedLCIv2Note()");
        }
        finally {
            if (sbMedRedLCIv2Note != null) {
                if (sbMedRedLCIv2Note.ToString().Length > 0) {
                    tempOutString = sbMedRedLCIv2Note.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        medRedLCIv2Note = tempOutString;
    }

    /// <summary>
    /// Creation of Note for MedRed - Two Minute Walk
    /// </summary>
    /// <param name="medRedTwoMinWalkTestSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="medRedTwoMinWalkTestNote"></param>
    private void SetupMedRedTwoMinWalkTestNote(SURVEY medRedTwoMinWalkTestSurvey, StringWriter writer, out string medRedTwoMinWalkTestNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbMedRedTwoMinWalkTestNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(medRedTwoMinWalkTestSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(medRedTwoMinWalkTestSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbMedRedTwoMinWalkTestNote.Append(titleLine);
                    sbMedRedTwoMinWalkTestNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbMedRedTwoMinWalkTestNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = medRedTwoMinWalkTestSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    case "DX":
                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMedRedTwoMinWalkTestNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMedRedTwoMinWalkTestNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbMedRedTwoMinWalkTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbMedRedTwoMinWalkTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbMedRedTwoMinWalkTestNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbMedRedTwoMinWalkTestNote.AppendLine();
                        }

                        break;

                    #region text-based questions

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getTwoMinWalkTestTrialName(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);

                            sbMedRedTwoMinWalkTestNote.Append(strNoteQuestion);
                            sbMedRedTwoMinWalkTestNote.AppendLine();

                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbMedRedTwoMinWalkTestNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbMedRedTwoMinWalkTestNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMedRedTwoMinWalkTestNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbMedRedTwoMinWalkTestNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupMedRedTwoMinWalkTestNote()");
        }
        finally {
            if (sbMedRedTwoMinWalkTestNote != null) {
                if (sbMedRedTwoMinWalkTestNote.ToString().Length > 0) {
                    tempOutString = sbMedRedTwoMinWalkTestNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        medRedTwoMinWalkTestNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Patients Global Impression of Change (PGIC) scale
    /// </summary>
    /// <param name="pgicSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="pgicNote"></param>
    private void SetupPGICNote(SURVEY pgicSurvey, StringWriter writer, out string pgicNote) 
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPGICNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(pgicSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(pgicSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbPGICNote.Append(titleLine);
                    sbPGICNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPGICNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = pgicSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":
                    case "1":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                sbPGICNote.Append(strNoteQuestion);
                            } else {
                                sbPGICNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbPGICNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                htmlWriter.Write(strNoteQuestion);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbPGICNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPGICNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbPGICNote.AppendLine();
                        }


                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions

                    #region Diagnosis Radios
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPGICNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPGICNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPGICNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbPGICNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Rehab Provider Dropdown
                    case "RP":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPGICNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPGICNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPGICNote.Append("\t"  + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPGICNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPGICNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Type of Service Dropdown
                    case "TS":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write( answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPGICNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPGICNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPGICNote.AppendLine();
                        }
                         htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();//TD
                            htmlWriter.RenderEndTag();//TR
                            sbPGICNote.AppendLine();
                      

                        if (question.Key.SkipSpace)
                        {
                            sbPGICNote.AppendLine();
                        }

                        break;
                    #endregion

                    case "2":
                    case "3":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion =  answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (question.Key.QUESTION_NUMBER != "3")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " out of 10.");
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPGICNote.Append(strNoteQuestion);
                            //added for formatting
                            sbPGICNote.AppendLine();
                          
                            if (question.Key.QUESTION_NUMBER != "3")
                            {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                sbPGICNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " out of 10.");
                            }
                            sbPGICNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbPGICNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPGICNote()");
        }
        finally {
            if (sbPGICNote != null) {
                if (sbPGICNote.ToString().Length > 0) {
                    tempOutString = sbPGICNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        pgicNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Neurobehavioral Symptom Inventory form
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupNSINote(SURVEY nsiSurvey, StringWriter writer, out string nsiNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbNSINote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(nsiSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(nsiSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                string disclaimerText = "Information collected in this instrument is not sufficient to use alone for diagnostic purposes.  Any assessment results need to be verified by the clinician collecting the data for accuracy and used in conjunction with appropriate clinical tools for developing a diagnosis and an individualized treatment plan.";

                foreach (string titleLine in instrumentTitle)
                {
                    sbNSINote.Append(titleLine);
                    sbNSINote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR

                sbNSINote.AppendLine();
                sbNSINote.Append(disclaimerText);
                sbNSINote.AppendLine();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(disclaimerText);
                htmlWriter.WriteBreak();

                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR

                
                sbNSINote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = nsiSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                sbNSINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            } else {
                                sbNSINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            }
                            sbNSINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbNSINote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbNSINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbNSINote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbNSINote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbNSINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbNSINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbNSINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbNSINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbNSINote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbNSINote.AppendLine();
                        }

                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbNSINote.Append(strNoteQuestion + ":");
                            sbNSINote.AppendLine();

                            sbNSINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbNSINote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbNSINote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupNSINote()");
        }
        finally {
            if (sbNSINote != null) {
                if (sbNSINote.ToString().Length > 0) {
                    tempOutString = sbNSINote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        nsiNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Disability Rating Scale
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupDisabilityRatingScaleNote(SURVEY drsSurvey, StringWriter writer, out string drsNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbDRSNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(drsSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(drsSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbDRSNote.Append(titleLine);
                    sbDRSNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbDRSNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = drsSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "DTE":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getDisabilityRatingScaleQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            //if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "DTE") {
                            //    htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                            //    htmlWriter.Write("&nbsp;");
                            //}
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbDRSNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbDRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbDRSNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbDRSNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbDRSNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbDRSNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbDRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbDRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbDRSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbDRSNote.AppendLine();
                        }

                        break;
                    case "TYP":
                    case "A":
                    case "B":
                    case "C":
                    case "D":
                    case "E":
                    case "F":
                    case "G":
                    case "H":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "TYP") {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            } else {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            }

                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_NAME != answer.STD_QUESTION_CHOICE.CHOICE_TEXT)
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbDRSNote.Append(strNoteQuestion);
                            sbDRSNote.AppendLine(); // new line for answer

                            sbDRSNote.Append(strNoteQuestion + ":");
                            sbDRSNote.AppendLine();
                            if (answer.STD_QUESTION_CHOICE.CHOICE_NAME != answer.STD_QUESTION_CHOICE.CHOICE_TEXT)
                            {
                                sbDRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                sbDRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbDRSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbDRSNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupDisabilityRatingScaleNote()");
        }
        finally {
            if (sbDRSNote != null) {
                if (sbDRSNote.ToString().Length > 0) {
                    tempOutString = sbDRSNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        drsNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for QUEST
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupQUESTNote(SURVEY questSurvey, StringWriter writer, out string questNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbQUESTNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(questSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(questSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbQUESTNote.Append(titleLine);
                    sbQUESTNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbQUESTNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = questSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "TechDev":
                    case "D":
                    case "1Comment":
                    case "2Comment":
                    case "3Comment":
                    case "4Comment":
                    case "5Comment":
                    case "6Comment":
                    case "7Comment":
                    case "8Comment":
                    case "9Comment":
                    case "10Comment":
                    case "11Comment":
                    case "12Comment":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            string questionNumber = getQUESTNoteQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "13") {
                                sbQUESTNote.Append(questionNumber + "Three most important satisfaction items:");
                                sbQUESTNote.AppendLine();

                                htmlWriter.Write(questionNumber + "Three most important satisfaction items");
                            } else {
                                sbQUESTNote.Append(questionNumber + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                sbQUESTNote.AppendLine();

                                htmlWriter.Write(questionNumber + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbQUESTNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbQUESTNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbQUESTNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbQUESTNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getQUESTNoteQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQUESTNote.Append(getQUESTNoteQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbQUESTNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbQUESTNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbQUESTNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbQUESTNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQUESTNote.AppendLine();
                        }

                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getQUESTNoteQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQUESTNote.Append(strNoteQuestion + ":");
                            sbQUESTNote.AppendLine();

                            sbQUESTNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbQUESTNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQUESTNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupQUESTNote()");
        }
        finally {
            if (sbQUESTNote != null) {
                if (sbQUESTNote.ToString().Length > 0) {
                    tempOutString = sbQUESTNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        questNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Satisfaction With Life Scale
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupSatisfactionWithLifeNote(SURVEY satisfactionSurvey, StringWriter writer, out string satisfactionNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbQSatisfactionNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(satisfactionSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(satisfactionSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbQSatisfactionNote.Append(titleLine);
                    sbQSatisfactionNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbQSatisfactionNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = satisfactionSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                sbQSatisfactionNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            } else {
                                sbQSatisfactionNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbQSatisfactionNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbQSatisfactionNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbQSatisfactionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbQSatisfactionNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbQSatisfactionNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQSatisfactionNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbQSatisfactionNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbQSatisfactionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbQSatisfactionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbQSatisfactionNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQSatisfactionNote.AppendLine();
                        }

                        break;
                    case "TYP":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getSatisfactionWithLifeScaleQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_NAME != answer.STD_QUESTION_CHOICE.CHOICE_TEXT)
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQSatisfactionNote.Append(strNoteQuestion);
                            sbQSatisfactionNote.AppendLine();
                            if (answer.STD_QUESTION_CHOICE.CHOICE_NAME != answer.STD_QUESTION_CHOICE.CHOICE_TEXT)
                            {
                                sbQSatisfactionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                sbQSatisfactionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbQSatisfactionNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQSatisfactionNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupSatisfactionWithLifeNote()");
        }
        finally {
            if (sbQSatisfactionNote != null) {
                if (sbQSatisfactionNote.ToString().Length > 0) {
                    tempOutString = sbQSatisfactionNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        satisfactionNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Functional Mobility Assessment
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupFunctionalMobilityAssessmentNote(SURVEY functionalMobilitySurvey, StringWriter writer, out string functionalMobilityNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbQFunctionalMobilityNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(functionalMobilitySurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(functionalMobilitySurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbQFunctionalMobilityNote.Append(titleLine);
                    sbQFunctionalMobilityNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbQFunctionalMobilityNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = functionalMobilitySurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":
                    case "2Comment":
                    case "2R":
                    case "3Comment":
                    case "3R":
                    case "4Comment":
                    case "4R":
                    case "5Comment":
                    case "5R":
                    case "6Comment":
                    case "6R":
                    case "7Comment":
                    case "7R":
                    case "8Comment":
                    case "8R":
                    case "9Comment":
                    case "9R":
                    case "10Comment":
                    case "10R":
                    case "11Comment":
                    case "11R":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            // note
                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                sbQFunctionalMobilityNote.Append(getFunctionalMobilityQuestionName(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER));
                            }
                            else
                            {
                                sbQFunctionalMobilityNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbQFunctionalMobilityNote.AppendLine();

                            if (!answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.Contains("R"))
                            {
                                sbQFunctionalMobilityNote.AppendLine();
                            }

                            // html
                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "1")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                    htmlWriter.Write("&nbsp;");
                                }
                                else
                                {
                                    htmlWriter.Write(getFunctionalMobilityQuestionName(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER));
                                    htmlWriter.Write("&nbsp;");
                                }
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                                htmlWriter.Write("&nbsp;");
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            string answerBuffer = "";

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.Contains("R"))
                            {
                                answerBuffer = ": ";
                            }
                            else
                            {
                                answerBuffer = "\t";
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbQFunctionalMobilityNote.Append(answerBuffer + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbQFunctionalMobilityNote.Append(answerBuffer + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbQFunctionalMobilityNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbQFunctionalMobilityNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "1":
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQFunctionalMobilityNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbQFunctionalMobilityNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbQFunctionalMobilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbQFunctionalMobilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbQFunctionalMobilityNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQFunctionalMobilityNote.AppendLine();
                        }

                        break;
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getFunctionalMobilityQuestionName(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + " - " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            //strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " ";
                            htmlWriter.Write(strNoteQuestion);
                            htmlWriter.Write("&nbsp;");

                            //htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT); // do not need - handled by getFunctionalMobilityQuestionName

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbQFunctionalMobilityNote.Append(strNoteQuestion + ":");
                            sbQFunctionalMobilityNote.AppendLine();

                            sbQFunctionalMobilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbQFunctionalMobilityNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbQFunctionalMobilityNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupFunctionalMobilityAssessmentNote()");
        }
        finally {
            if (sbQFunctionalMobilityNote != null) {
                if (sbQFunctionalMobilityNote.ToString().Length > 0) {
                    tempOutString = sbQFunctionalMobilityNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        functionalMobilityNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Berg Balance Scale
    /// </summary>
    /// <param name="nsiSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="nsiNote"></param>
    private void SetupBergBalanceScaleNote(SURVEY bergBalanceScaleSurvey, StringWriter writer, out string bergBalanceScaleNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbBergBalanceScaleNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(bergBalanceScaleSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(bergBalanceScaleSurvey.STD_SURVEY_TYPE_ID).Title;
            //}

            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbBergBalanceScaleNote.Append(titleLine);
                    sbBergBalanceScaleNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbBergBalanceScaleNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = bergBalanceScaleSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":
                    case "15":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getBergBalanceQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbBergBalanceScaleNote.Append(strNoteQuestion + ":");
                            sbBergBalanceScaleNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbBergBalanceScaleNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbBergBalanceScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbBergBalanceScaleNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbBergBalanceScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getBergBalanceQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbBergBalanceScaleNote.Append(strNoteQuestion + ":");
                            sbBergBalanceScaleNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbBergBalanceScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbBergBalanceScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbBergBalanceScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbBergBalanceScaleNote.AppendLine();
                        }

                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                        foreach (var answer in question) {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getBergBalanceQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbBergBalanceScaleNote.Append(strNoteQuestion + ":");
                            sbBergBalanceScaleNote.AppendLine();
                            sbBergBalanceScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbBergBalanceScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbBergBalanceScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupBergBalanceScaleNote()");
        }
        finally {
            if (sbBergBalanceScaleNote != null) {
                if (sbBergBalanceScaleNote.ToString().Length > 0) {
                    tempOutString = sbBergBalanceScaleNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        bergBalanceScaleNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for VA Low Vision Visual Functioning (VA LV VFQ 20) Survey
    /// </summary>
    /// <param name="vaLowVisionSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="vaLowVisionNote"></param>
    private void SetupVALowVisionNote(SURVEY vaLowVisionSurvey, StringWriter writer, out string vaLowVisionNote) {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbVaLowVisionNote = new StringBuilder();
        string tempOutString = "";

        try {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(vaLowVisionSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
                instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(vaLowVisionSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0) {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle) {
                    sbVaLowVisionNote.Append(titleLine);
                    sbVaLowVisionNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbVaLowVisionNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = vaLowVisionSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList()) {
                switch (question.Key.QUESTION_NUMBER) {

                    #region text-based questions

                    case "D":
                    case "22":
                    case "23":
                    case "24":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getVALowVisionQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();

                            sbVaLowVisionNote.Append(strNoteQuestion + ":");
                            sbVaLowVisionNote.AppendLine();

                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue) {
                                sbVaLowVisionNote.Append("\t" + answer.RESULT_TEXT);
                            } else {
                                sbVaLowVisionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbVaLowVisionNote.AppendLine();
                        }
                        if (question.Key.SkipSpace) {
                            sbVaLowVisionNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getVALowVisionQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT)) {
                                strDetail = ": " + answer.RESULT_TEXT;
                            } else {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbVaLowVisionNote.Append(strNoteQuestion + ":");
                            sbVaLowVisionNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other") {
                                sbVaLowVisionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            } else {
                                sbVaLowVisionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbVaLowVisionNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbVaLowVisionNote.AppendLine();
                        }

                        break;
                    case "TYP":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":
                    case "18":
                    case "19":
                    case "20":
                    case "21":

                        foreach (var answer in question) {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getVALowVisionQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbVaLowVisionNote.Append(strNoteQuestion + ":");
                            sbVaLowVisionNote.AppendLine();

                            sbVaLowVisionNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbVaLowVisionNote.AppendLine();
                        }

                        if (question.Key.SkipSpace) {
                            sbVaLowVisionNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupVALowVisionNote()");
        }
        finally
        {
            if (sbVaLowVisionNote != null)
            {
                if (sbVaLowVisionNote.ToString().Length > 0)
                {
                    tempOutString = sbVaLowVisionNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        vaLowVisionNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for PART-O Survey
    /// </summary>
    /// <param name="partOSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="PartONote"></param>
    private void SetupPART_ONote(SURVEY partOSurvey, StringWriter writer, out string PartONote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPartONote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(partOSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPartONote.Append(titleLine);
                    sbPartONote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPartONote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = partOSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "23", "22", "21", "20", "19" ,"18" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                        //Insert newline
                        sbPartONote.AppendLine();

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            sbPartONote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPartONote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - ");
                            }
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPartONote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPartONote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPartONote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPartONote.AppendLine();
                        }

                        break;
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":
                    case "23":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbPartONote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            sbPartONote.Append(getPART_OQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPartONote.AppendLine();

                            htmlWriter.Write(getPART_OQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPartONote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPartONote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPartONote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPartONote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbPartONote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(" : " + answer.RESULT_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPartONote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPartONote.AppendLine();
                            sbPartONote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPartONote.Append(" : " + answer.RESULT_TEXT);
                            }
                            sbPartONote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPartONote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbPartONote.AppendLine();

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPART_OQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                            htmlWriter.Write(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPartONote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPartONote.AppendLine();
                            sbPartONote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPartONote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPartONote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPartONote()");
        }
        finally
        {
            if (sbPartONote != null)
            {
                if (sbPartONote.ToString().Length > 0)
                {
                    tempOutString = sbPartONote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        PartONote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for MPAI-4 Survey
    /// </summary>
    /// <param name="MPAISurvey"></param>
    /// <param name="writer"></param>
    /// <param name="MPAINote"></param>
    private void SetupMPAI_4Note(SURVEY MPAISurvey, StringWriter writer, out string MPAINote)
        {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbMPAINote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(MPAISurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbMPAINote.Append(titleLine);
                    sbMPAINote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbMPAINote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = MPAISurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "46", "45", "44", "43", "42", "41", "40", "39", "38", "37" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // text-based questions
                    case "D":
                    case "36":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D" && answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "36")
                            {
                                sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            else
                            {
                                sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbMPAINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D" && answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "36")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbMPAINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMPAINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }

                        break;

                    case "37":
                    case "38":
                    case "39":
                    case "40":
                    case "41":
                    case "42":
                    case "43":
                    case "44":
                    case "45":
                    case "46":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMPAINote.AppendLine();

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbMPAINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMPAINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }

                        break;


                    #endregion

                    #region Diagnosis question

                    // Diagnosis question
                    case "DX":
                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(" : " + answer.RESULT_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMPAINote.AppendLine();
                            sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbMPAINote.Append(" : " + answer.RESULT_TEXT);
                            }
                            sbMPAINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "SUBTYP":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7A":
                    case "7B":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":
                    case "23":
                    case "24":
                    case "25":
                    case "26":
                    case "27":
                    case "28A":
                    case "28B":
                    case "28B1":
                    case "29":
                    case "30PRE":
                    case "30POST":
                    case "31PRE":
                    case "31POST":
                    case "32PRE":
                    case "32POST":
                    case "33PRE":
                    case "33POST":
                    case "34PRE":
                    case "34POST":
                    case "35PRE":
                    case "35POST":
                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - ";
                            htmlWriter.Write(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMPAINote.Append(strNoteQuestion + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMPAINote.AppendLine();
                            sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbMPAINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }

                        break;

                    case "QRPT":
                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " - ";
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbMPAINote.AppendLine();
                            sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbMPAINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }
                        break;

                    case "QRPT1":
                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbMPAINote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            //if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D" && answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "36")
                            //{
                            //    sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER + " " + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            //}
                            //else
                            //{
                            sbMPAINote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            //}
                            sbMPAINote.AppendLine();

                            //if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D" && answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "36")
                            //{
                            //    htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                            //    htmlWriter.Write("&nbsp;");
                            //}
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbMPAINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbMPAINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbMPAINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbMPAINote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupMPAI_4Note()");
        }
        finally
        {
            if (sbMPAINote != null)
            {
                if (sbMPAINote.ToString().Length > 0)
                {
                    tempOutString = sbMPAINote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        MPAINote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for JFK Coma Recovery Scale Survey
    /// </summary>
    /// <param name="JFKComaRecoveryScaleSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="JFKComaRecoveryScaleNote"></param>
    private void SetupJFKComaRecoveryScaleNote(SURVEY JFKComaRecoveryScaleSurvey, StringWriter writer, out string JFKComaRecoveryScaleNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbJFKComaRecoveryScaleNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(JFKComaRecoveryScaleSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbJFKComaRecoveryScaleNote.Append(titleLine);
                    sbJFKComaRecoveryScaleNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbJFKComaRecoveryScaleNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = JFKComaRecoveryScaleSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "7" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(6, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "Etiology":
                    case "DateOnset":
                    case "DateAdmission":
                    case "D":
                    case "7":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getJFKComaRecoveryScaleQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbJFKComaRecoveryScaleNote.Append(strNoteQuestion + ":");
                            sbJFKComaRecoveryScaleNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbJFKComaRecoveryScaleNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbJFKComaRecoveryScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getJFKComaRecoveryScaleQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbJFKComaRecoveryScaleNote.Append(strNoteQuestion + ":");
                            sbJFKComaRecoveryScaleNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbJFKComaRecoveryScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbJFKComaRecoveryScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }

                        break;

                    case "Week":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getJFKComaRecoveryScaleQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbJFKComaRecoveryScaleNote.Append(strNoteQuestion + ":");
                            sbJFKComaRecoveryScaleNote.AppendLine();
                            sbJFKComaRecoveryScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbJFKComaRecoveryScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupJFKComaRecoveryScaleNote()");
        }
        finally
        {
            if (sbJFKComaRecoveryScaleNote != null)
            {
                if (sbJFKComaRecoveryScaleNote.ToString().Length > 0)
                {
                    tempOutString = sbJFKComaRecoveryScaleNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        JFKComaRecoveryScaleNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Oswestry Low Back Pain Disability Survey
    /// </summary>
    /// <param name="OswestryLowBackPainDisabilitySurvey"></param>
    /// <param name="writer"></param>
    /// <param name="OswestryLowBackPainDisabilityNote"></param>
    private void SetupOswestryLowBackPainDisabilityNote(SURVEY OswestryLowBackPainDisabilitySurvey, StringWriter writer, out string OswestryLowBackPainDisabilityNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbOswestryLowBackPainDisabilityNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(OswestryLowBackPainDisabilitySurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbOswestryLowBackPainDisabilityNote.Append(titleLine);
                    sbOswestryLowBackPainDisabilityNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbOswestryLowBackPainDisabilityNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = OswestryLowBackPainDisabilitySurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "13", "12", "11" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "11":
                    case "12":
                    case "13":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getOswestryLBPDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbOswestryLowBackPainDisabilityNote.Append(strNoteQuestion + ":");
                            sbOswestryLowBackPainDisabilityNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbOswestryLowBackPainDisabilityNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbOswestryLowBackPainDisabilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getOswestryLBPDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbOswestryLowBackPainDisabilityNote.Append(strNoteQuestion + ":");
                            sbOswestryLowBackPainDisabilityNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbOswestryLowBackPainDisabilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbOswestryLowBackPainDisabilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getOswestryLBPDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbOswestryLowBackPainDisabilityNote.Append(strNoteQuestion + ":");
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                            sbOswestryLowBackPainDisabilityNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbOswestryLowBackPainDisabilityNote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupOswestryLowBackPainDisabilityNote()");
        }
        finally
        {
            if (sbOswestryLowBackPainDisabilityNote != null)
            {
                if (sbOswestryLowBackPainDisabilityNote.ToString().Length > 0)
                {
                    tempOutString = sbOswestryLowBackPainDisabilityNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        OswestryLowBackPainDisabilityNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Timed Up And Go Note
    /// </summary>
    /// <param name="timedUpAndGoSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="timedUpAndGoNote"></param>
    private void SetupTimedUpAndGoNote(SURVEY timedUpAndGoSurvey, StringWriter writer, out string timedUpAndGoNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbTimedUpAndGoNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(timedUpAndGoSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbTimedUpAndGoNote.Append(titleLine);
                    sbTimedUpAndGoNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbTimedUpAndGoNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = timedUpAndGoSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "9", "8" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            var q2Index = sortedQuestions.FindIndex(c => c.Key.QUESTION_NUMBER == "2");

            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                if (q2Index < 0)
                    sortedQuestions.Insert(3, actualTopItem);
                else
                    sortedQuestions.Insert(4, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "8":
                    case "9":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getTimedUpAndGoQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbTimedUpAndGoNote.Append(strNoteQuestion + ":");
                            sbTimedUpAndGoNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbTimedUpAndGoNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbTimedUpAndGoNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbTimedUpAndGoNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbTimedUpAndGoNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getTimedUpAndGoQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbTimedUpAndGoNote.Append(strNoteQuestion + ":");
                            sbTimedUpAndGoNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbTimedUpAndGoNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbTimedUpAndGoNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbTimedUpAndGoNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbTimedUpAndGoNote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "7":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getTimedUpAndGoQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbTimedUpAndGoNote.Append(strNoteQuestion + ":");
                            sbTimedUpAndGoNote.AppendLine();
                            sbTimedUpAndGoNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbTimedUpAndGoNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbTimedUpAndGoNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupTimedUpAndGoNote()");
        }
        finally
        {
            if (sbTimedUpAndGoNote != null)
            {
                if (sbTimedUpAndGoNote.ToString().Length > 0)
                {
                    tempOutString = sbTimedUpAndGoNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        timedUpAndGoNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Generalized Anxiety Disorder Scale Survey
    /// </summary>
    /// <param name="GeneralizedAnxietyDisorderScaleSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="GeneralizedAnxietyDisorderScaleNote"></param>
    private void SetupGeneralizedAnxietyDisorderScaleNote(SURVEY GeneralizedAnxietyDisorderScaleSurvey, StringWriter writer, out string GeneralizedAnxietyDisorderScaleNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbGeneralizedAnxietyDisorderScaleNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(GeneralizedAnxietyDisorderScaleSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbGeneralizedAnxietyDisorderScaleNote.Append(titleLine);
                    sbGeneralizedAnxietyDisorderScaleNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = GeneralizedAnxietyDisorderScaleSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "8" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "8":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getGAD7QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbGeneralizedAnxietyDisorderScaleNote.Append(strNoteQuestion + ":");
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbGeneralizedAnxietyDisorderScaleNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbGeneralizedAnxietyDisorderScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getGAD7QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbGeneralizedAnxietyDisorderScaleNote.Append(strNoteQuestion + ":");
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbGeneralizedAnxietyDisorderScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbGeneralizedAnxietyDisorderScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getGAD7QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbGeneralizedAnxietyDisorderScaleNote.Append(strNoteQuestion + ":");
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                            sbGeneralizedAnxietyDisorderScaleNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbGeneralizedAnxietyDisorderScaleNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupGeneralizedAnxietyDisorderScaleNote()");
        }
        finally
        {
            if (sbGeneralizedAnxietyDisorderScaleNote != null)
            {
                if (sbGeneralizedAnxietyDisorderScaleNote.ToString().Length > 0)
                {
                    tempOutString = sbGeneralizedAnxietyDisorderScaleNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        GeneralizedAnxietyDisorderScaleNote = tempOutString;
    }


    /// <summary>
    /// Creation of Note for Post Traumatic Stress Disorder (PTSD) CheckList - Civilian Version Survey
    /// </summary>
    /// <param name="PCLCSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="PCLCNote"></param>
    private void SetupPCLCNote(SURVEY PCLCSurvey, StringWriter writer, out string PCLCNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPCLCNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(PCLCSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPCLCNote.Append(titleLine);
                    sbPCLCNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPCLCNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = PCLCSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "18" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "18":
                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbPCLCNote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPCLCQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPCLCNote.Append(strNoteQuestion + ":");
                            sbPCLCNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPCLCNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPCLCNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPCLCNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPCLCNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPCLCQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPCLCNote.Append(strNoteQuestion + ":");
                            sbPCLCNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPCLCNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPCLCNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPCLCNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPCLCNote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":

                        foreach (var answer in question)
                        {
                            //Insert newline
                            sbPCLCNote.AppendLine();
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPCLCQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPCLCNote.Append(strNoteQuestion + ":");
                            sbPCLCNote.AppendLine();
                            sbPCLCNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPCLCNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPCLCNote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPCLCNote()");
        }
        finally
        {
            if (sbPCLCNote != null)
            {
                if (sbPCLCNote.ToString().Length > 0)
                {
                    tempOutString = sbPCLCNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        PCLCNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Patient Health Questionnaire - 9 Survey
    /// </summary>
    /// <param name="PHQ9Survey"></param>
    /// <param name="writer"></param>
    /// <param name="PHQ9Note"></param>
    private void SetupPHQ9Note(SURVEY PHQ9Survey, StringWriter writer, out string PHQ9Note)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPHQ9Note = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(PHQ9Survey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPHQ9Note.Append(titleLine);
                    sbPHQ9Note.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPHQ9Note.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = PHQ9Survey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "10" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "10":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPHQ9QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPHQ9Note.Append(strNoteQuestion + ":");
                            sbPHQ9Note.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPHQ9Note.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPHQ9Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPHQ9Note.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPHQ9Note.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPHQ9QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPHQ9Note.Append(strNoteQuestion + ":");
                            sbPHQ9Note.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPHQ9Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPHQ9Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPHQ9Note.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPHQ9Note.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "11":


                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPHQ9QuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPHQ9Note.Append(strNoteQuestion + ":");
                            sbPHQ9Note.AppendLine();
                            sbPHQ9Note.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPHQ9Note.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPHQ9Note.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPHQ9Note()");
        }
        finally
        {
            if (sbPHQ9Note != null)
            {
                if (sbPHQ9Note.ToString().Length > 0)
                {
                    tempOutString = sbPHQ9Note.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        PHQ9Note = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Insomnia Severity Index Survey
    /// </summary>
    /// <param name="ISISurvey"></param>
    /// <param name="writer"></param>
    /// <param name="ISINote"></param>
    private void SetupISINote(SURVEY ISISurvey, StringWriter writer, out string ISINote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbISINote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(ISISurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbISINote.Append(titleLine);
                    sbISINote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbISINote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = ISISurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "8" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    case "D":
                    case "8":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getInsomniaSeverityIndexQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbISINote.Append(strNoteQuestion + ":");
                            sbISINote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbISINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbISINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbISINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbISINote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getInsomniaSeverityIndexQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbISINote.Append(strNoteQuestion + ":");
                            sbISINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbISINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbISINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbISINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbISINote.AppendLine();
                        }

                        break;

                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getInsomniaSeverityIndexQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbISINote.Append(strNoteQuestion + ":");
                            sbISINote.AppendLine();
                            sbISINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbISINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbISINote.AppendLine();
                        }

                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupISINote()");
        }
        finally
        {
            if (sbISINote != null)
            {
                if (sbISINote.ToString().Length > 0)
                {
                    tempOutString = sbISINote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        ISINote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Pain Outcomes Questionnaire VA Long Form - Intake (POQI)
    /// </summary>
    /// <param name="POQISurvey"></param>
    /// <param name="writer"></param>
    /// <param name="POQINote"></param>
    private void SetupPOQINote(SURVEY POQISurvey, StringWriter writer, out string POQINote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPOQINote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(POQISurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPOQINote.Append(titleLine);
                    sbPOQINote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPOQINote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = POQISurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;
            string strLastQuestionNo = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    //case "D": Removed due to duplication from Doug's feedback
                    case "1":
                    case "2":
                    case "7":
                    case "15":
                    case "16":
                    case "37":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQINote.Append(strNoteQuestion + ":");
                            sbPOQINote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPOQINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }
                        break;

                    // "Years-Months" text-based questions
                    case "14":
                    case "40":
                    case "43":
                    case "44":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQINote.Append(strNoteQuestion + ":");
                            sbPOQINote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                htmlWriter.Write("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));

                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //sbPOQINote.Append("\t" + answer.RESULT_TEXT);
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                sbPOQINote.Append("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));
                            }
                            else
                            {
                                sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }
                        break;

                    #endregion

                    #region Radio Button List questions

                    // radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQINote.Append(strNoteQuestion + ":");
                            sbPOQINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPOQINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button based questions
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "9":
                    case "11":
                    case "36":
                    case "38":
                    case "39":
                    case "42":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQINote.Append(strNoteQuestion + ":");
                            sbPOQINote.AppendLine();
                            sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPOQINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }

                        break;

                    // CheckBoxList based questions
                    case "8":
                    case "10":
                    case "17":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != strLastQuestionNo)
                            {
                                strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));
                            }
                            else
                            {
                                htmlWriter.Write("");
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != strLastQuestionNo)
                            {
                                sbPOQINote.Append(strNoteQuestion + ":");
                                sbPOQINote.AppendLine();
                            }
                            sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPOQINote.AppendLine();

                            strLastQuestionNo = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }

                        break;

                    // "Scale 0 to 10" radion-button based questions
                    case "12":
                    case "13":
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":
                    case "23":
                    case "24":
                    case "25":
                    case "26":
                    case "27":
                    case "28":
                    case "29":
                    case "30":
                    case "31":
                    case "32":
                    case "33":
                    case "34":
                    case "35":
                    case "41":
                    case "45":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQINote.Append(strNoteQuestion + ":");
                            sbPOQINote.AppendLine();
                            sbPOQINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");
                            sbPOQINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQINote.AppendLine();
                        }

                        break;


                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPOQINote()");
        }
        finally
        {
            if (sbPOQINote != null)
            {
                if (sbPOQINote.ToString().Length > 0)
                {
                    tempOutString = sbPOQINote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        POQINote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Pain Outcomes Questionnaire VA Long Form - Discharge (POQD)
    /// </summary>
    /// <param name="POQDSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="POQDNote"></param>
    private void SetupPOQDNote(SURVEY POQDSurvey, StringWriter writer, out string POQDNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPOQDNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(POQDSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPOQDNote.Append(titleLine);
                    sbPOQDNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPOQDNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = POQDSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    //case "D": Removed due to duplication from Doug's feedback
                    case "1":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQDNote.Append(strNoteQuestion + ":");
                            sbPOQDNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPOQDNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQDNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQDNote.AppendLine();
                        }
                        break;

                    // "Years-Months" text-based questions
                    case "27":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQDNote.Append(strNoteQuestion + ":");
                            sbPOQDNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                htmlWriter.Write("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));

                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //sbPOQDNote.Append("\t" + answer.RESULT_TEXT);
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                sbPOQDNote.Append("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));
                            }
                            else
                            {
                                sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQDNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQDNote.AppendLine();
                        }
                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQDNote.Append(strNoteQuestion + ":");
                            sbPOQDNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPOQDNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQDNote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "26":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQDNote.Append(strNoteQuestion + ":");
                            sbPOQDNote.AppendLine();
                            sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPOQDNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQDNote.AppendLine();
                        }

                        break;

                    // "Scale 0 to 10" radio-button questions
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":
                    case "23":
                    case "24":
                    case "25":
                    case "28":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQDQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQDNote.Append(strNoteQuestion + ":");
                            sbPOQDNote.AppendLine();
                            sbPOQDNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");
                            sbPOQDNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQDNote.AppendLine();
                        }

                        break;


                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPOQDNote()");
        }
        finally
        {
            if (sbPOQDNote != null)
            {
                if (sbPOQDNote.ToString().Length > 0)
                {
                    tempOutString = sbPOQDNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        POQDNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Pain Outcomes Questionnaire VA Long Form - Follow Up (POQF)
    /// </summary>
    /// <param name="POQFSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="POQFNote"></param>
    private void SetupPOQFNote(SURVEY POQFSurvey, StringWriter writer, out string POQFNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPOQFNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(POQFSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPOQFNote.Append(titleLine);
                    sbPOQFNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPOQFNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = POQFSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    //case "D": Removed due to duplication from Doug's feedback
                    case "1":
                    case "3":
                    case "4":
                    case "5":
                    case "28":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQFQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQFNote.Append(strNoteQuestion + ":");
                            sbPOQFNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPOQFNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQFNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQFNote.AppendLine();
                        }
                        break;

                    // "Years-Months" text-based questions
                    case "31":
                    case "34":
                    case "35":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQFQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbPOQFNote.Append(strNoteQuestion + ":");
                            sbPOQFNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                htmlWriter.Write("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));

                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                //sbPOQFNote.Append("\t" + answer.RESULT_TEXT);
                                int months = 0;
                                int years = 0;
                                getYearsMonths(answer.RESULT_TEXT, out years, out months);
                                sbPOQFNote.Append("\t" + ((years == 0) ? "" : years.ToString() + " years ") + ((months == 0) ? "" : months.ToString() + " months"));
                            }
                            else
                            {
                                sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPOQFNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPOQFNote.AppendLine();
                        }
                        break;

                    #endregion

                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQFQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQFNote.Append(strNoteQuestion + ":");
                            sbPOQFNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPOQFNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQFNote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "2":
                    case "27":
                    case "29":
                    case "30":
                    case "33":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQFQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQFNote.Append(strNoteQuestion + ":");
                            sbPOQFNote.AppendLine();
                            sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbPOQFNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQFNote.AppendLine();
                        }

                        break;

                    // "Scale 0 to 10" radio-button questions
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                    case "10":
                    case "11":
                    case "12":
                    case "13":
                    case "14":
                    case "15":
                    case "16":
                    case "17":
                    case "18":
                    case "19":
                    case "20":
                    case "21":
                    case "22":
                    case "23":
                    case "24":
                    case "25":
                    case "26":
                    case "32":
                    case "36":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getPOQFQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPOQFNote.Append(strNoteQuestion + ":");
                            sbPOQFNote.AppendLine();
                            sbPOQFNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " (on a scale of 0 to 10)");
                            sbPOQFNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPOQFNote.AppendLine();
                        }

                        break;


                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPOQFNote()");
        }
        finally
        {
            if (sbPOQFNote != null)
            {
                if (sbPOQFNote.ToString().Length > 0)
                {
                    tempOutString = sbPOQFNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        POQFNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for World Health Organization Disability Assessment Schedule 2.0 - Interview
    /// </summary>
    /// <param name="WHODASISurvey"></param>
    /// <param name="writer"></param>
    /// <param name="WHODASINote"></param>
    private void SetupWHODASINote(SURVEY WHODASISurvey, StringWriter writer, out string WHODASINote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbWHODASINote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(WHODASISurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbWHODASINote.Append(titleLine);
                    sbWHODASINote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbWHODASINote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = WHODASISurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            //Manually place question numbers that are total scores directly below
            //diagnosis and assessment date in the note display.
            List<string> displayFirst = new List<string>(new string[] { "S12Score", "S11Score", "S5Score" });
            var sortedQuestions = questions.OrderBy(c => c.Key.SORT_ORDER).ToList();
            foreach (string qNum in displayFirst)
            {
                var topItemIndex = sortedQuestions.FindIndex(x => x.Key.QUESTION_NUMBER == qNum);
                var actualTopItem = sortedQuestions[topItemIndex];
                sortedQuestions.RemoveAt(topItemIndex);
                sortedQuestions.Insert(2, actualTopItem);
            }

            foreach (var question in sortedQuestions)
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    case "D":
                    case "F1":
                    case "F2":
                    case "F3":
                    case "F4":
                    case "A2":
                    case "A3":
                    case "H1":
                    case "H2":
                    case "H3":
                    case "S5Score":
                    case "S11Score":
                    case "S12Score":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbWHODASINote.Append(strNoteQuestion + ":");
                            sbWHODASINote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbWHODASINote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbWHODASINote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbWHODASINote.AppendLine();
                        }
                        break;

                    #endregion


                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASINote.Append(strNoteQuestion + ":");
                            sbWHODASINote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbWHODASINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbWHODASINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASINote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "F5":
                    case "A1":
                    case "A4":
                    case "S1":
                    case "S2":
                    case "S3":
                    case "S4":
                    case "S5":
                    case "S6":
                    case "S7":
                    case "S8":
                    case "S9":
                    case "S10":
                    case "S11":
                    case "S12":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASINote.Append(strNoteQuestion + ":");
                            sbWHODASINote.AppendLine();
                            sbWHODASINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbWHODASINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASINote.AppendLine();
                        }
                        break;

                    // Radio-button list with "Other" textbox
                    case "A5":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.RESULT_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASINote.Append(strNoteQuestion + ":");
                            sbWHODASINote.AppendLine();
                            sbWHODASINote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.RESULT_TEXT);
                            sbWHODASINote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASINote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupWHODASINote()");
        }
        finally
        {
            if (sbWHODASINote != null)
            {
                if (sbWHODASINote.ToString().Length > 0)
                {
                    tempOutString = sbWHODASINote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        WHODASINote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for World Health Organization Disability Assessment Schedule 2.0 - Proxy
    /// </summary>
    /// <param name="WHODASPSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="WHODASPNote"></param>
    private void SetupWHODASPNote(SURVEY WHODASPSurvey, StringWriter writer, out string WHODASPNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbWHODASPNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(WHODASPSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbWHODASPNote.Append(titleLine);
                    sbWHODASPNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbWHODASPNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = WHODASPSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    case "D":
                    case "H1":
                    case "H2":
                    case "H3":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASPQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbWHODASPNote.Append(strNoteQuestion + ":");
                            sbWHODASPNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbWHODASPNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASPNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbWHODASPNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbWHODASPNote.AppendLine();
                        }
                        break;

                    #endregion


                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASPQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASPNote.Append(strNoteQuestion + ":");
                            sbWHODASPNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbWHODASPNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASPNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbWHODASPNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASPNote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "S1":
                    case "S2":
                    case "S3":
                    case "S4":
                    case "S5":
                    case "S6":
                    case "S7":
                    case "S8":
                    case "S9":
                    case "S10":
                    case "S11":
                    case "S12":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASPQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASPNote.Append(strNoteQuestion + ":");
                            sbWHODASPNote.AppendLine();
                            sbWHODASPNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbWHODASPNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASPNote.AppendLine();
                        }
                        break;

                    // Radio-button list with "Other" textbox
                    case "H4":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASPQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.RESULT_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASPNote.Append(strNoteQuestion + ":");
                            sbWHODASPNote.AppendLine();
                            sbWHODASPNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.RESULT_TEXT);
                            sbWHODASPNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASPNote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupWHODASPNote()");
        }
        finally
        {
            if (sbWHODASPNote != null)
            {
                if (sbWHODASPNote.ToString().Length > 0)
                {
                    tempOutString = sbWHODASPNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        WHODASPNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for World Health Organization Disability Assessment Schedule 2.0 - Self
    /// </summary>
    /// <param name="WHODASSSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="WHODASSNote"></param>
    private void SetupWHODASSNote(SURVEY WHODASSSurvey, StringWriter writer, out string WHODASSNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbWHODASSNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(WHODASSSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbWHODASSNote.Append(titleLine);
                    sbWHODASSNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbWHODASSNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = WHODASSSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    case "D":
                    case "H1":
                    case "H2":
                    case "H3":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbWHODASSNote.Append(strNoteQuestion + ":");
                            sbWHODASSNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbWHODASSNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbWHODASSNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbWHODASSNote.AppendLine();
                        }
                        break;

                    #endregion


                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASSNote.Append(strNoteQuestion + ":");
                            sbWHODASSNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbWHODASSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbWHODASSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbWHODASSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASSNote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "S1":
                    case "S2":
                    case "S3":
                    case "S4":
                    case "S5":
                    case "S6":
                    case "S7":
                    case "S8":
                    case "S9":
                    case "S10":
                    case "S11":
                    case "S12":

                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getWHODASSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbWHODASSNote.Append(strNoteQuestion + ":");
                            sbWHODASSNote.AppendLine();
                            sbWHODASSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbWHODASSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbWHODASSNote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupWHODASSNote()");
        }
        finally
        {
            if (sbWHODASSNote != null)
            {
                if (sbWHODASSNote.ToString().Length > 0)
                {
                    tempOutString = sbWHODASSNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        WHODASSNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Supervision Rating Scale
    /// </summary>
    /// <param name="SRSSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="SRSNote"></param>
    private void SetupSRSNote(SURVEY SRSSurvey, StringWriter writer, out string SRSNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbSRSNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(SRSSurvey.STD_SURVEY_TYPE_ID).Title;
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbSRSNote.Append(titleLine);
                    sbSRSNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbSRSNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            var questions = SRSSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {

                    #region text-based questions

                    // "Regular" text-based questions
                    case "D":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getSRSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            sbSRSNote.Append(strNoteQuestion + ":");
                            sbSRSNote.AppendLine();

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbSRSNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbSRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbSRSNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbSRSNote.AppendLine();
                        }
                        break;

                    #endregion


                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getSRSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbSRSNote.Append(strNoteQuestion + ":");
                            sbSRSNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbSRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbSRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbSRSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbSRSNote.AppendLine();
                        }

                        break;

                    // "Regular" radio-button questions
                    case "1":
                        foreach (var answer in question)
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getSRSQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbSRSNote.Append(strNoteQuestion + ":");
                            sbSRSNote.AppendLine();
                            sbSRSNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbSRSNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbSRSNote.AppendLine();
                        }
                        break;

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupSRSNote()");
        }
        finally
        {
            if (sbSRSNote != null)
            {
                if (sbSRSNote.ToString().Length > 0)
                {
                    tempOutString = sbSRSNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        SRSNote = tempOutString;
    }

    /// <summary>
    /// Creation of Note for Optimal Instrument
    /// </summary>
    /// <param name="OptimalSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="OptimalNote"></param>
    private void SetupOptimalNote(SURVEY OptimalSurvey, StringWriter writer, out string OptimalNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbOptimalNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(OptimalSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(OptimalSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbOptimalNote.Append(titleLine);
                    sbOptimalNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbOptimalNote.AppendLine();
            }

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("\t" + System.DateTime.Now.ToShortDateString());

            sbOptimalNote.Append("Survey Date:");
            sbOptimalNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            sbOptimalNote.AppendLine();
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            htmlWriter.WriteBreak();
            #endregion


            #region Render questions and responses

            var questions = OptimalSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                if (question.Key.QUESTION_NUMBER == "Total Score" )
                {
                    foreach (var answer in question)
                    {

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                        strNoteQuestion = getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                        sbOptimalNote.Append(strNoteQuestion);
                        sbOptimalNote.AppendLine();

                        htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                        if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                        {
                            htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                        }
                        else
                        {
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                        }
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                        {
                            sbOptimalNote.Append("\t" + answer.RESULT_TEXT);
                        }
                        else
                        {
                            sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                        }

                        sbOptimalNote.AppendLine();
                    }
                    if (question.Key.SkipSpace)
                    {
                        sbOptimalNote.AppendLine();
                    }
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                    htmlWriter.Write("<br />");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                }
                else
                {
                    switch (question.Key.QUESTION_NUMBER)
                    {
                        #region Radio Button List questions
                        //here
                        //radio-button based questions
                        case "Patient Status":

                        case "DX":
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                strNoteQuestion = getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                                {
                                    strDetail = ": " + answer.RESULT_TEXT;
                                }
                                else
                                {
                                    strDetail = String.Empty;
                                }

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbOptimalNote.Append(getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                sbOptimalNote.AppendLine();

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                sbOptimalNote.AppendLine();
                                if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT == "Patient Status")
                                {
                                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                    htmlWriter.Write("<br />");
                                    htmlWriter.RenderEndTag();
                                    htmlWriter.RenderEndTag();
                                }
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbOptimalNote.AppendLine();
                            }


                            break;
                        case "1":
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                //getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) +
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                sbOptimalNote.Append(strNoteQuestion);
                                sbOptimalNote.AppendLine();

                                switch (answer.STD_QUESTION_CHOICE.CHOICE_NAME)
                                {
                                    case "Occupation":
                                        htmlWriter.Write(answer.RESULT_TEXT);
                                        sbOptimalNote.Append("\t" + answer.RESULT_TEXT);
                                        break;
                                    default://answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + 
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        break;
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbOptimalNote.AppendLine();
                            }
                            break;
                        case "2":
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                //getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) +
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                sbOptimalNote.Append(strNoteQuestion);
                                sbOptimalNote.AppendLine();

                                switch (answer.STD_QUESTION_CHOICE.CHOICE_NAME)
                                {
                                    case "5":
                                        htmlWriter.Write(answer.RESULT_TEXT);
                                        sbOptimalNote.Append("\t" + answer.RESULT_TEXT);
                                        break;
                                    default://answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + 
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT.Replace("?", ""));
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT.Replace("?", ""));
                                        break;
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbOptimalNote.AppendLine();
                            }
                            break;
                        case "3":
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                //getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) +
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                sbOptimalNote.Append(strNoteQuestion);
                                sbOptimalNote.AppendLine();

                                switch (answer.STD_QUESTION_CHOICE.CHOICE_NAME)
                                {
                                    case "7":
                                        htmlWriter.Write(answer.RESULT_TEXT);
                                        sbOptimalNote.Append("\t" + answer.RESULT_TEXT);
                                        break;
                                    default://answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + 
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        break;
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbOptimalNote.AppendLine();
                            }
                            break;
                        case "4":
                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                //getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) +
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                sbOptimalNote.Append(strNoteQuestion);
                                sbOptimalNote.AppendLine();

                                switch (answer.STD_QUESTION_CHOICE.CHOICE_NAME)
                                {
                                    case "8":
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        break;
                                    default://answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + 
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        break;
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbOptimalNote.AppendLine();
                            }
                            break;
                        case "6":
                        case "7":
                        case "8":
                        case "9":
                        case "10":
                        case "11":
                        case "12":
                        case "13":
                        case "14":
                        case "Baseline Difficulty-1":
                        case "Baseline Difficulty-2":
                        case "Baseline Difficulty-3":
                        case "Baseline Difficulty-4":
                        case "Baseline Difficulty-5":
                        case "Baseline Difficulty-6":
                        case "Baseline Difficulty-7":
                        case "Baseline Difficulty-8":
                        case "Baseline Difficulty-9":
                        case "Baseline Difficulty-10":
                        case "Baseline Difficulty-11":
                        case "Baseline Difficulty-12":
                        case "Baseline Difficulty-13":
                        case "Baseline Difficulty-14":
                        case "Baseline Difficulty-15":
                        case "Baseline Difficulty-16":
                        case "Baseline Difficulty-17":
                        case "Baseline Difficulty-18":
                        case "Baseline Difficulty-19":
                        case "Baseline Difficulty-20":
                        case "Baseline Difficulty-21":
                        case "Baseline Difficulty-22":
                        case "Baseline Difficulty-23a":
                        case "Baseline Difficulty-23b":
                        case "Baseline Difficulty-23c":
                        case "Baseline Difficulty-24":



                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                //getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) +

                                if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "Baseline Difficulty-23a" &&
                                    answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "Baseline Difficulty-23b" &&
                                    answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "Baseline Difficulty-23c" &&
                                    answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "Baseline Difficulty-24"
                                    )
                                {
                                    strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.Replace("Baseline Difficulty-", "") + ". " + removePrecedingLineBreaks(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT.Replace("\r\n", "<br />"));
                                }
                                else
                                {
                                    strNoteQuestion = removePrecedingLineBreaks(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT.Replace("\r\n", "<br />"));
                                }
                                htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                //strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.Replace("Baseline Difficulty-", "") + ". " + removePrecedingLineBreaks(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT.Replace("\r\n", "<br />"));
                                //htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER.Replace("Baseline Difficulty-", "") + ". " + removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                                sbOptimalNote.Append(strNoteQuestion);
                                sbOptimalNote.AppendLine();
                                switch (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                                {
                                    case "Baseline Difficulty-23a":
                                    case "Baseline Difficulty-23b":
                                    case "Baseline Difficulty-23c":
                                    case "Baseline Difficulty-24":
                                        htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                                        sbOptimalNote.Append("\t" + answer.RESULT_TEXT);
                                        break;
                                    default://answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + 
                                        htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        sbOptimalNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        break;
                                }
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "Baseline Difficulty-22")
                                {


                                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                    htmlWriter.Write("<br />");
                                    htmlWriter.RenderEndTag();
                                    htmlWriter.RenderEndTag();
                                    sbOptimalNote.AppendLine();

                                }

                                sbOptimalNote.AppendLine();
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbOptimalNote.AppendLine();
                            }

                            break;

                        #endregion



                        //listbox questions

                        // anything else
                        default:
                            break;
                    }
                }
            }

            #endregion
            
            #region footer HTML
        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "center");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
        htmlWriter.Write("Copyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved.");
        /*htmlWriter.WriteBreak();
        htmlWriter.RenderEndTag();//Bold
        htmlWriter.RenderEndTag();//TD
        htmlWriter.RenderEndTag();//TR
        */
        sbOptimalNote.Append("\tCopyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved.");
        sbOptimalNote.AppendLine();
        #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupOptimalNote()");
        }
        finally
        {
            if (sbOptimalNote != null)
            {
                if (sbOptimalNote.ToString().Length > 0)
                {
                    tempOutString = sbOptimalNote.ToString();
                }
            }
        }
        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        OptimalNote = tempOutString;
    }

    private void SetupPainInterferenceShortForm6a(SURVEY PainInterferenceSurvey, StringWriter writer, out string PainInterferenceNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPainInterferenceShortForm6aNote = new StringBuilder();
        string tempOutString = "";
        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(PainInterferenceSurvey.STD_SURVEY_TYPE_ID).Title;


            if (instrumentTitle.Count > 0)
            {
                #region Instrument Title
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPainInterferenceShortForm6aNote.Append(titleLine);
                    sbPainInterferenceShortForm6aNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPainInterferenceShortForm6aNote.AppendLine();
                #endregion
            }

            #region CopyRight Title
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

            sbPainInterferenceShortForm6aNote.Append("PROMIS SF V1.0 – Physical Function w Mobility Aid © 2008-2012 PROMIS Health Organization and PROMIS Cooperative Group");
            sbPainInterferenceShortForm6aNote.AppendLine();

            htmlWriter.Write("PROMIS SF V1.0 – Physical Function w Mobility Aid © 2008-2012 PROMIS Health Organization and PROMIS Cooperative Group");
            htmlWriter.WriteBreak();

            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbPainInterferenceShortForm6aNote.AppendLine();
            #endregion

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.Write("&nbsp;");
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbPainInterferenceShortForm6aNote.AppendLine();
            // Move scores to the top of the list

            #region Raw Score
            //Add Raw Score
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Raw Score");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(rawScore);
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbPainInterferenceShortForm6aNote.Append("Raw Score:");
            sbPainInterferenceShortForm6aNote.Append("\t" + rawScore);
            sbPainInterferenceShortForm6aNote.AppendLine();
            #endregion

            #endregion

            #region Render questions and responses

            var questions = PainInterferenceSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {
                    #region text-based questions

                    case "D":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                sbPainInterferenceShortForm6aNote.Append(strNoteQuestion);
                            }
                            else
                            {
                                sbPainInterferenceShortForm6aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbPainInterferenceShortForm6aNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                htmlWriter.Write(strNoteQuestion);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPainInterferenceShortForm6aNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPainInterferenceShortForm6aNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPainInterferenceShortForm6aNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button and Dropdown List questions

                    //radio-button based questions
                        #region Diagonosis Dropdown
                        case "DX":

                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                                {
                                    strDetail = ": " + answer.RESULT_TEXT;
                                }
                                else
                                {
                                    strDetail = String.Empty;
                                }

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbPainInterferenceShortForm6aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                sbPainInterferenceShortForm6aNote.AppendLine();

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }
                        
                            break;
                        #endregion

                        #region Rehab Provider Dropdown
                        case "RP":

                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                                {
                                    strDetail = ": " + answer.RESULT_TEXT;
                                }
                                else
                                {
                                    strDetail = String.Empty;
                                }

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbPainInterferenceShortForm6aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                sbPainInterferenceShortForm6aNote.AppendLine();

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            break;
                        #endregion

                        #region Type of Service Dropdown
                        case "TS":

                            foreach (var answer in question)
                            {

                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                                {
                                    strDetail = ": " + answer.RESULT_TEXT;
                                }
                                else
                                {
                                    strDetail = String.Empty;
                                }

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbPainInterferenceShortForm6aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                                sbPainInterferenceShortForm6aNote.AppendLine();

                                if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                                }
                                else
                                {
                                    sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();//TD
                            htmlWriter.RenderEndTag();//TR
                            sbPainInterferenceShortForm6aNote.AppendLine();

                            if (question.Key.SkipSpace)
                            {
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            break;
                        #endregion                   

                        #region Radio-Based Questions

                        case "-1":
                        case "1":
                        case "2":
                        case "3":
                        case "4":
                        case "5":
                        case "6":

                            foreach (var answer in question)
                            {
                                #region NoteType
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                                if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                                {
                                    strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                                   // htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                    htmlWriter.Write("&nbsp;");
                                }
                                else
                                {
                                    strNoteQuestion = String.Empty;
                                }
                                string s = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                                if (s.Substring(0, 2) == "0 " || s.Substring(0, 2) == "1 " || s.Substring(0, 2) == "2 " || s.Substring(0, 2) == "3 " || s.Substring(0, 2) == "4 ")
                                {
                                    s = s.Substring(2, s.Length - 2);
                                }

                                if (question.Key.QUESTION_NUMBER == "-1")
                                {
                                    _notetype = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                                }

                                #endregion

                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                                htmlWriter.Write(strNoteQuestion);

                                htmlWriter.RenderEndTag();
                                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                if (question.Key.QUESTION_NUMBER != "-1")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }

                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();

                                sbPainInterferenceShortForm6aNote.Append(strNoteQuestion);
                                //added for formatting
                                sbPainInterferenceShortForm6aNote.AppendLine();

                                sbPainInterferenceShortForm6aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            if (question.Key.SkipSpace)
                            {
                                sbPainInterferenceShortForm6aNote.AppendLine();
                            }

                            break;
                        #endregion

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPainInterferenceNoteNote()");
        }
        finally
        {
            //insert instance of care
            if (_notetype != "Initial")
            {
                var prom1InstanceOfCareNote = SqlProvider.ExecuteScalar("RegistryConnectionString", "[TBI].[SP_InsertInstanceOfCareNote]", new object[] { survey.patient_ICN, survey.SURVEYS_ID, _notetype, _surveyDate, Session["InstanceNumber"].ToString() });
            }

            if (sbPainInterferenceShortForm6aNote != null)
            {
                if (sbPainInterferenceShortForm6aNote.ToString().Length > 0)
                {
                    tempOutString = sbPainInterferenceShortForm6aNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        // assign output param
        PainInterferenceNote = tempOutString;
    }
    private void SetupPhysicalFunctionwMobilityAid(SURVEY PhysicalFunctionwMobilityAidSurvey, StringWriter writer, out string MobilityAidNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbPhysicalFunctionwMobilityAidNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(PhysicalFunctionwMobilityAidSurvey.STD_SURVEY_TYPE_ID).Title;


            if (instrumentTitle.Count > 0)
            {
                #region Instrument Title
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbPhysicalFunctionwMobilityAidNote.Append(titleLine);
                    sbPhysicalFunctionwMobilityAidNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbPhysicalFunctionwMobilityAidNote.AppendLine();
                #endregion
            }

            #region CopyRight Title
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

            sbPhysicalFunctionwMobilityAidNote.Append("PROMIS SF V1.0 – Physical Function w Mobility Aid © 2008-2012 PROMIS Health Organization and PROMIS Cooperative Group");
            sbPhysicalFunctionwMobilityAidNote.AppendLine();

            htmlWriter.Write("PROMIS SF V1.0 – Physical Function w Mobility Aid © 2008-2012 PROMIS Health Organization and PROMIS Cooperative Group");
            htmlWriter.WriteBreak();

            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbPhysicalFunctionwMobilityAidNote.AppendLine();
            #endregion

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("\t" + System.DateTime.Now.ToShortDateString());

            sbPhysicalFunctionwMobilityAidNote.Append("Survey Date:");
            sbPhysicalFunctionwMobilityAidNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            htmlWriter.WriteBreak();
            sbPhysicalFunctionwMobilityAidNote.AppendLine();

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.Write("&nbsp;");
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbPhysicalFunctionwMobilityAidNote.AppendLine();
            // Move scores to the top of the list
            #region Raw Score
            //Add Raw Score
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Raw Score");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(Session["rawScore"].ToString());
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbPhysicalFunctionwMobilityAidNote.Append("Raw Score:");
            sbPhysicalFunctionwMobilityAidNote.Append("\t" + rawScore);
            sbPhysicalFunctionwMobilityAidNote.AppendLine();
            #endregion

            #endregion

            #region Render questions and responses

            var questions = PhysicalFunctionwMobilityAidSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {
                    #region text-based questions

                    case "D":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append(strNoteQuestion);
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                htmlWriter.Write(strNoteQuestion);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button and Dropdown List questions

                    //radio-button based questions
                    #region Diagonosis Dropdown
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPhysicalFunctionwMobilityAidNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Rehab Provider Dropdown
                    case "RP":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPhysicalFunctionwMobilityAidNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Type of Service Dropdown
                    case "TS":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPhysicalFunctionwMobilityAidNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                         htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();//TD
                            htmlWriter.RenderEndTag();//TR
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();

                        if (question.Key.SkipSpace)
                        {
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Radio-Based Questions

                    case "-1":
                    case "Support":
                    case "PFC6":
                    case "PFC29":
                    case "PF_17":
                    case "PFA55":
                    case "PFC45":
                    case "PFC53":
                    case "PFA9":
                    case "PFA20":
                    case "PFA12":
                    case "PF_23":
                    case "PF_53":

                        foreach (var answer in question)
                        {
                            #region NoteType
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                            {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                                // htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            else
                            {
                                strNoteQuestion = String.Empty;
                            }
                            string s = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                            if (question.Key.QUESTION_NUMBER == "-1")
                            {
                                _notetype = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                            }
                            #endregion

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (question.Key.QUESTION_NUMBER != "-1")
                            {
                                if (question.Key.QUESTION_NUMBER != "Support")
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                                else
                                {
                                    htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbPhysicalFunctionwMobilityAidNote.Append(strNoteQuestion);
                            //added for formatting
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                            if (question.Key.QUESTION_NUMBER != "-1")
                            {
                                if (question.Key.QUESTION_NUMBER != "Support")
                                {
                                    sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + getTextAnswerForDifficulty(answer.STD_QUESTION_CHOICE.CHOICE_TEXT));
                                }
                                else
                                {
                                    sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                }
                            }
                            else
                            {
                                sbPhysicalFunctionwMobilityAidNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbPhysicalFunctionwMobilityAidNote.AppendLine();
                        }

                        break;
                    #endregion

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPainInterferenceNoteNote()");
        }
        finally
        {
            if (_notetype != "Initial")
            {
                var prom2InstanceOfCareNote = SqlProvider.ExecuteScalar("RegistryConnectionString", "[TBI].[SP_InsertInstanceOfCareNote]", new object[] { survey.patient_ICN, survey.SURVEYS_ID, _notetype, _surveyDate, Session["InstanceNumber"].ToString() });
            }

            if (sbPhysicalFunctionwMobilityAidNote != null)
            {
                if (sbPhysicalFunctionwMobilityAidNote.ToString().Length > 0)
                {
                    tempOutString = sbPhysicalFunctionwMobilityAidNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        MobilityAidNote = tempOutString;
    }

    private string getTextAnswerForDifficulty(string _questionAnswer)
    {
        string answerText = "Without any difficulty";
        switch (_questionAnswer)
        {
            case "2": answerText = "With a little difficulty"; break;
            case "3": answerText = "With some difficulty"; break;
            case "4": answerText = "With much difficulty"; break;
            case "5": answerText = "Unable to do"; break;
        }
        return answerText;
    }

    private string getScoreAnswerForDifficulty(string _questionAnswer)
    {
        string answerRank = "6";
        switch (_questionAnswer.Trim())
        {
            case "1": answerRank = "Able to do without any difficulty"; break;
            case "2": answerRank = "Able to do with little difficulty"; break;
            case "3": answerRank = "Able to do with moderate difficulty"; break;
            case "4":  answerRank = "Able to do with much difficulty"; break;
            case "5": answerRank = "Unable to do"; break;
        }
        return answerRank;
    }

    private string getScoreChoiceForDifficulty(string _choiceAnswer)
    {
        string answerRank = "";
        switch (_choiceAnswer.Trim())
        {
            case "Able to do without any difficulty": answerRank = "1"; break;
            case "Able to do with little difficulty": answerRank = "2"; break;
            case "Able to do with moderate difficulty": answerRank = "3"; break;
            case "Able to do with much difficulty": answerRank = "4"; break;
            case "Unable to do": answerRank = "5"; break;
        }
        return answerRank;
    }
    
    private void SetupUpperExtremityShortForm7a(SURVEY UpperExtremityShortForm7aSurvey, StringWriter writer, out string UpperExtremityShortForm7aNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbUpperExtremityShortForm7aNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(UpperExtremityShortForm7aSurvey.STD_SURVEY_TYPE_ID).Title;


            if (instrumentTitle.Count > 0)
            {
                #region Instrument Title
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbUpperExtremityShortForm7aNote.Append(titleLine);
                    sbUpperExtremityShortForm7aNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbUpperExtremityShortForm7aNote.AppendLine();
                #endregion
            }


            #region CopyRight Title
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

            sbUpperExtremityShortForm7aNote.Append("PROMIS Item Bank v2.0 – Upper Extremity – Short Form 7a © 2010-2016 PROMIS Health Organization and PROMIS Cooperative Group");
            sbUpperExtremityShortForm7aNote.AppendLine();

            htmlWriter.Write("PROMIS Item Bank v2.0 – Upper Extremity – Short Form 7a © 2010-2016 PROMIS Health Organization and PROMIS Cooperative Group");
            htmlWriter.WriteBreak();


            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//TD
            htmlWriter.RenderEndTag();//TR
            sbUpperExtremityShortForm7aNote.AppendLine();
            #endregion

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("\t" + System.DateTime.Now.ToShortDateString());

            sbUpperExtremityShortForm7aNote.Append("Survey Date:");
            sbUpperExtremityShortForm7aNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            htmlWriter.WriteBreak();
            sbUpperExtremityShortForm7aNote.AppendLine();
            // Move scores to the top of the list
            #region Raw Score
            //Add Raw Score
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Raw Score");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write(rawScore);
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            sbUpperExtremityShortForm7aNote.Append("Raw Score:");
            sbUpperExtremityShortForm7aNote.Append("\t" + rawScore);
            sbUpperExtremityShortForm7aNote.AppendLine();
            #endregion

            #endregion

            #region Render questions and responses

            var questions = UpperExtremityShortForm7aSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {
                    #region text-based questions

                    case "D":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                            {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                                // htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            else
                            {
                                strNoteQuestion = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                sbUpperExtremityShortForm7aNote.Append(strNoteQuestion);
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }
                            sbUpperExtremityShortForm7aNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "D")
                            {
                                htmlWriter.Write(strNoteQuestion);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region Radio Button and Dropdown List questions

                    //radio-button based questions
                    #region Diagonosis Dropdown
                    case "DX":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbUpperExtremityShortForm7aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbUpperExtremityShortForm7aNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Rehab Provider Dropdown
                    case "RP":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbUpperExtremityShortForm7aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbUpperExtremityShortForm7aNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Type of Service Dropdown
                    case "TS":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "45%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbUpperExtremityShortForm7aNote.Append(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbUpperExtremityShortForm7aNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }
                        
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();//TD
                            htmlWriter.RenderEndTag();//TR
                            sbUpperExtremityShortForm7aNote.AppendLine();

                        if (question.Key.SkipSpace)
                        {
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        break;
                    #endregion

                    #region Radio-Based Questions

                    case "-1":
                    case "PFA14r1":
                    case "PFA34":
                    case "PFA36":
                    case "PFB13":
                    case "PFB28r1":
                    case "PFB34":
                    case "PFM16":
                    case "PFHeader":

                        foreach (var answer in question)
                        {
                            #region NoteType
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "55%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                            if (question.Key.QUESTION_NUMBER != "-1" && question.Key.QUESTION_NUMBER != "0")
                            {
                                strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                                // htmlWriter.Write(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER);
                                htmlWriter.Write("&nbsp;");
                            }
                            else
                            {
                                strNoteQuestion = String.Empty;
                            }
                            string s = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                            if (question.Key.QUESTION_NUMBER == "-1")
                            {
                                _notetype = answer.STD_QUESTION_CHOICE.CHOICE_TEXT;
                            }
                            #endregion

                            strNoteQuestion = answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(strNoteQuestion);

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "-1")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbUpperExtremityShortForm7aNote.Append(strNoteQuestion);
                            //added for formatting
                            sbUpperExtremityShortForm7aNote.AppendLine();
                            if (answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER != "-1")
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + getTextAnswerForDifficulty(answer.STD_QUESTION_CHOICE.CHOICE_TEXT));
                            }
                            else
                            {
                                sbUpperExtremityShortForm7aNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + " - Note");
                            }
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbUpperExtremityShortForm7aNote.AppendLine();
                        }

                        break;
                    #endregion

                    #endregion

                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupPainInterferenceNoteNote()");
        }
        finally
        {
            if (_notetype != "Initial")
            {
                var prom3InstanceOfCareNote = SqlProvider.ExecuteScalar("RegistryConnectionString", "[TBI].[SP_InsertInstanceOfCareNote]", new object[] { survey.patient_ICN, survey.SURVEYS_ID, _notetype, _surveyDate, Session["InstanceNumber"].ToString() });
            }
            if (sbUpperExtremityShortForm7aNote != null)
            {
                if (sbUpperExtremityShortForm7aNote.ToString().Length > 0)
                {
                    tempOutString = sbUpperExtremityShortForm7aNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        UpperExtremityShortForm7aNote = tempOutString;
    }
  
    /// <summary>
    /// Creation of Note for Rehab FollowUp Instrument
    /// </summary>
    /// <param name="RehabFollowUpSurvey"></param>
    /// <param name="writer"></param>
    /// <param name="RehabFollowUpNote"></param>
    private void SetupRehabFollowUpNote(SURVEY RehabFollowUpSurvey, StringWriter writer, out string RehabFollowUpNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbRehabFollowUpNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(RehabFollowUpSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(RehabFollowUpSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbRehabFollowUpNote.Append(titleLine);
                    sbRehabFollowUpNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbRehabFollowUpNote.AppendLine();
            }

            #endregion

            #region Render questions and responses

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("\t" + System.DateTime.Now.ToShortDateString());

            sbRehabFollowUpNote.Append("Survey Date:");
            sbRehabFollowUpNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            sbRehabFollowUpNote.AppendLine();
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            htmlWriter.WriteBreak();

            var questions = RehabFollowUpSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                switch (question.Key.QUESTION_NUMBER)
                {
                    #region Radio Button List questions

                    //radio-button based questions
                    case "DX":
                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getRehabFollowUpQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (!String.IsNullOrEmpty(answer.RESULT_TEXT))
                            {
                                strDetail = ": " + answer.RESULT_TEXT;
                            }
                            else
                            {
                                strDetail = String.Empty;
                            }

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbRehabFollowUpNote.Append(getLCIQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT + ":");
                            sbRehabFollowUpNote.AppendLine();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                            {
                                sbRehabFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT + ": " + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbRehabFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            sbRehabFollowUpNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbRehabFollowUpNote.AppendLine();
                        }
                          htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                    htmlWriter.Write("<br />");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                    sbRehabFollowUpNote.AppendLine();

                        break;
                    case "Respondent": //Rehabilitation Setting
                    case "Rehabilitation Setting":
                    case "Activity":
                    case "Environment":
                    case "Health Status":
                    case "Participation":
                    case "Quality of Life":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getRehabFollowUpQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);

                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            sbRehabFollowUpNote.Append(strNoteQuestion);
                            sbRehabFollowUpNote.AppendLine();

                            sbRehabFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_NAME + " - " + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            sbRehabFollowUpNote.AppendLine();
                        }

                        if (question.Key.SkipSpace)
                        {
                            sbRehabFollowUpNote.AppendLine();
                        }

                        break;

                    #endregion

                    #region text-based questions


                    case "Date of Follow up":
                    case "Discharge Date":
                    case "Total Score":

                        foreach (var answer in question)
                        {

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            strNoteQuestion = getRehabFollowUpQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                            sbRehabFollowUpNote.Append(strNoteQuestion);
                            sbRehabFollowUpNote.AppendLine();

                            htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                            htmlWriter.RenderEndTag();
                            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                            }
                            else
                            {
                                htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                            {
                                sbRehabFollowUpNote.Append("\t" + answer.RESULT_TEXT);
                            }
                            else
                            {
                                sbRehabFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                            }

                            sbRehabFollowUpNote.AppendLine();
                        }
                        if (question.Key.SkipSpace)
                        {
                            sbRehabFollowUpNote.AppendLine();
                        }

                        break;

                    #endregion

                    //listbox questions

                    // anything else
                    default:
                        break;
                }
            }

            #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupRehabFollowUpNote()");
        }
        finally
        {
            if (sbRehabFollowUpNote != null)
            {
                if (sbRehabFollowUpNote.ToString().Length > 0)
                {
                    tempOutString = sbRehabFollowUpNote.ToString();
                }
            }
        }
        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();

        #endregion

        RehabFollowUpNote = tempOutString;
    }
    private void SetupOptimalFollowUpNote(SURVEY OptimalFollowUpSurvey, StringWriter writer, out string OptimalFollowUpNote)
    {
        HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
        StringBuilder sbOptimalFollowUpNote = new StringBuilder();
        string tempOutString = "";

        try
        {

            #region HTML writer create html page start

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "70%");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

            #endregion

            #region Instrument Title Rendering

            List<string> instrumentTitle;
            //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
            //{
            //    instrumentTitle = _tbiVIAInstrumentManager.GetInstrumentByID(OptimalSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            //else
            //{
            instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(OptimalFollowUpSurvey.STD_SURVEY_TYPE_ID).Title;
            //}
            if (instrumentTitle.Count > 0)
            {
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Center");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                foreach (string titleLine in instrumentTitle)
                {
                    sbOptimalFollowUpNote.Append(titleLine);
                    sbOptimalFollowUpNote.AppendLine();

                    htmlWriter.Write(titleLine);
                    htmlWriter.WriteBreak();
                }

                htmlWriter.RenderEndTag();//Bold
                htmlWriter.RenderEndTag();//TD
                htmlWriter.RenderEndTag();//TR
                sbOptimalFollowUpNote.AppendLine();
            }

            #endregion

            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("Survey Date");
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
            htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
            htmlWriter.Write("\t" + System.DateTime.Now.ToShortDateString());

            sbOptimalFollowUpNote.Append("Survey Date:");
            sbOptimalFollowUpNote.Append("\t" + System.DateTime.Now.ToShortDateString());
            sbOptimalFollowUpNote.AppendLine();
            htmlWriter.RenderEndTag();//Bold
            htmlWriter.RenderEndTag();//Td
            htmlWriter.RenderEndTag();//Tr
            htmlWriter.WriteBreak();

            #region Render questions and responses

            var questions = OptimalFollowUpSurvey.SURVEY_RESULTs.Where(SURVEY_RESULTs => SURVEY_RESULTs.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER != null).GroupBy(c => new { c.STD_QUESTION_CHOICE.STD_QUESTION.ID, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, c.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, c.STD_QUESTION_CHOICE.STD_QUESTION.SORT_ORDER, c.STD_QUESTION_CHOICE.STD_QUESTION.SkipSpace });

            string strDetail = String.Empty;
            string strNoteQuestion = String.Empty;
            int _counter = 5;
        

            foreach (var question in questions.OrderBy(c => c.Key.SORT_ORDER).ToList())
            {
                if (question.Key.QUESTION_NUMBER == "Total Score")
                {
                    #region text-based questions


                    foreach (var answer in question)
                    {

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);
                        strNoteQuestion = getOptimalQuestionNumber(answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) + answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT;
                        sbOptimalFollowUpNote.Append(strNoteQuestion);
                        sbOptimalFollowUpNote.AppendLine();

                        htmlWriter.Write(removePrecedingLineBreaks(strNoteQuestion.Replace("\r\n", "<br />")));

                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.B);

                        if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                        {
                            htmlWriter.Write(answer.RESULT_TEXT + "&nbsp;");
                        }
                        else
                        {
                            htmlWriter.Write(answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                        }
                         htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        if (answer.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
                        {
                            sbOptimalFollowUpNote.Append("\t" + answer.RESULT_TEXT);
                        }
                        else
                        {
                            sbOptimalFollowUpNote.Append("\t" + answer.STD_QUESTION_CHOICE.CHOICE_TEXT);
                        }

                        sbOptimalFollowUpNote.AppendLine();
                    }
                    if (question.Key.SkipSpace)
                    {
                        sbOptimalFollowUpNote.AppendLine();
                    }

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                    htmlWriter.Write("<br />");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                    sbOptimalFollowUpNote.AppendLine();

                    #endregion

                }
                else
                {
                    //if (("Follow Up Difficulty-" + (_counter - 4).ToString()) == (question.Key.QUESTION_NUMBER))
                    //{
                    switch (question.Key.QUESTION_NUMBER)
                    {

                        //here
                        //radio-button based questions

                        case "Follow Up Difficulty-1":
                            Q1 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-2":
                             Q2 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-3":
                             Q3 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-4":
                             Q4 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-5":
                             Q5 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-6":
                             Q6 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-7":
                             Q7 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-8":
                             Q8 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-9":
                             Q9 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-10":
                             Q10 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-11":
                             Q11 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-12":
                             Q12 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-13":
                             Q13 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-14":
                             Q14 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-15":
                             Q15 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-16":
                             Q16 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-17":
                             Q17 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-18":
                             Q18 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-19":
                             Q19 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-20":
                             Q20 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-21":
                             Q21 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        case "Follow Up Difficulty-22":
                             Q22 = true;
                            foreach (var answer in question) 
                            {
                                SetAnswerText(question.Key.QUESTION_NUMBER, htmlWriter, strNoteQuestion, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER, answer.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT, answer.STD_QUESTION_CHOICE.CHOICE_TEXT, sbOptimalFollowUpNote);
                            }
                            _counter++;
                            break;
                        default:
                            break;

                    } 
                }
            }

            #endregion

            #region footer HTML
        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
        htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "100%");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "center");
        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
        htmlWriter.Write("Copyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved.");
        /*htmlWriter.WriteBreak();
        htmlWriter.RenderEndTag();//Bold
        htmlWriter.RenderEndTag();//TD
        htmlWriter.RenderEndTag();//TR
        */
        sbOptimalFollowUpNote.Append("Copyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved.");
        sbOptimalFollowUpNote.AppendLine();
        #endregion

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentSummaryNote.aspx", "100026", "SetupOptimalNote()");
        }
        finally
        {
            if (sbOptimalFollowUpNote != null)
            {
                if (sbOptimalFollowUpNote.ToString().Length > 0)
                {
                    tempOutString = sbOptimalFollowUpNote.ToString();
                }
            }
        }

        #region Finalize HTML

        //table
        htmlWriter.RenderEndTag();
        //center
        htmlWriter.RenderEndTag();
        //body
        htmlWriter.RenderEndTag();
        //html
        htmlWriter.RenderEndTag();

        SurveyNoteHTML.Text = writer.ToString();


        #endregion

        OptimalFollowUpNote = tempOutString;
}

    #region UTILITY METHODS

    /// <summary>
    /// Calculates number of years and months based on number of months
    /// </summary>
    /// <returns></returns>
    private void getYearsMonths(string strMonths, out int years, out int months)
    {
        int.TryParse(strMonths, out months);
        years = (int)Math.Truncate((double)months / 12);
        months = months - 12 * years;
    }

  
    protected void SetAnswerText(string _realQuestionNumber, HtmlTextWriter _htmlWriter, string _strNoteQuestion, string questionNumber, string questionText, string choiceText, StringBuilder _sbOptimalFollowUpNote)
    {
        _htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
        _htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "67%");
        _htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
        _htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
        _htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

        _strNoteQuestion = getOptimalQuestionNumber(_realQuestionNumber) + questionText;
        _htmlWriter.Write(_realQuestionNumber.Replace("Follow Up Difficulty-", "") + ". " + removePrecedingLineBreaks(_strNoteQuestion.Replace("\r\n", "<br />")));

        _htmlWriter.RenderEndTag();
        _htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.Width, "33%");
        _htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
        _htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
        _htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

        if (choiceText != "Not Applicable")
        {
            _htmlWriter.Write(getScoreChoiceForDifficulty(choiceText) + " - " + choiceText);
        }
        else
        {
            _htmlWriter.Write(choiceText);
        }
        _htmlWriter.RenderEndTag();
        _htmlWriter.RenderEndTag();

        _sbOptimalFollowUpNote.Append(_realQuestionNumber.Replace("Follow Up Difficulty-", "") + ". " + _strNoteQuestion);
        _sbOptimalFollowUpNote.AppendLine();

        if (choiceText != "Not Applicable")
        {
            _sbOptimalFollowUpNote.Append("\t" + getScoreChoiceForDifficulty(choiceText) + " - " + choiceText);
        }
        else
        {
            _sbOptimalFollowUpNote.Append("\t" + choiceText );
        }
        _sbOptimalFollowUpNote.AppendLine();

    }
    /// <summary>
    /// Method takes question number from database and transforms to requested display string for JFK ComaRecovery Scale
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getJFKComaRecoveryScaleQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "Etiology":
            case "DateOnset":
            case "DateAdmission":
            case "D":
            case "Week":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n";
                break;
            default:
                break;
        }

        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for Oswestry LBPD
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getOswestryLBPDQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n";
                break;
            case "2":
                returnStr = "\r\n";
                break;
            case "3":
                returnStr = "\r\n";
                break;
            case "4":
                returnStr = "\r\n";
                break;
            case "5":
                returnStr = "\r\n";
                break;
            case "6":
                returnStr = "\r\n";
                break;
            case "7":
                returnStr = "\r\n";
                break;
            case "8":
                returnStr = "\r\n";
                break;
            case "9":
                returnStr = "\r\n";
                break;
            case "10":
                returnStr = "\r\n";
                break;
            case "11":
                returnStr = "\r\n";
                break;
            case "12":
                returnStr = "\r\n";
                break;
            case "13":
                returnStr = "\r\n";
                break;
            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for PCLC
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPCLCQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "8 - ";
                break;
            case "9":
                returnStr = "9 - ";
                break;
            case "10":
                returnStr = "10 - ";
                break;
            case "11":
                returnStr = "11 -";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "13":
                returnStr = "13 - ";
                break;
            case "14":
                returnStr = "14 - ";
                break;
            case "15":
                returnStr = "15 - ";
                break;
            case "16":
                returnStr = "16 - ";
                break;
            case "17":
                returnStr = "17 - ";
                break;
            case "18":
                returnStr = "";
                break;
            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for PHQ-9
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPHQ9QuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n8 - ";
                break;
            case "9":
                returnStr = "\r\n9 - ";
                break;
            case "10":
                returnStr = "\r\n";
                break;
            case "11":
                returnStr = "\r\n";
                break;
            default:
                break;
        }
        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string for Insomnia Severity Index
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getInsomniaSeverityIndexQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n";
                break;
            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for POQI
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPOQIQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n8 - ";
                break;
            case "9":
                returnStr = "\r\n9 - ";
                break;
            case "10":
                returnStr = "\r\n10 - ";
                break;
            case "11":
                returnStr = "\r\n11 -";
                break;
            case "12":
                returnStr = "\r\n12 - ";
                break;
            case "13":
                returnStr = "\r\n13 - ";
                break;
            case "14":
                returnStr = "\r\n14 - ";
                break;
            case "15":
                returnStr = "\r\n15 - ";
                break;
            case "16":
                returnStr = "\r\n16 - ";
                break;
            case "17":
                returnStr = "\r\n17 - ";
                break;
            case "18":
                returnStr = "\r\n18 - ";
                break;
            case "19":
                returnStr = "\r\n19 - ";
                break;
            case "20":
                returnStr = "\r\n20 - ";
                break;
            case "21":
                returnStr = "\r\n21 - ";
                break;
            case "22":
                returnStr = "\r\n22 - ";
                break;
            case "23":
                returnStr = "\r\n23 - ";
                break;
            case "24":
                returnStr = "\r\n24 - ";
                break;
            case "25":
                returnStr = "\r\n25 - ";
                break;
            case "26":
                returnStr = "\r\n26 - ";
                break;
            case "27":
                returnStr = "\r\n27 - ";
                break;
            case "28":
                returnStr = "\r\n28 - ";
                break;
            case "29":
                returnStr = "\r\n29 - ";
                break;
            case "30":
                returnStr = "\r\n30 - ";
                break;
            case "31":
                returnStr = "\r\n31 - ";
                break;
            case "32":
                returnStr = "\r\n32 - ";
                break;
            case "33":
                returnStr = "\r\n33 - ";
                break;
            case "34":
                returnStr = "\r\n34 - ";
                break;
            case "35":
                returnStr = "\r\n35 - ";
                break;
            case "36":
                returnStr = "\r\n36 - ";
                break;
            case "37":
                returnStr = "\r\n37 - ";
                break;
            case "38":
                returnStr = "\r\n38 - ";
                break;
            case "39":
                returnStr = "\r\n39 - ";
                break;
            case "40":
                returnStr = "\r\n40 - ";
                break;
            case "41":
                returnStr = "\r\n41 - ";
                break;
            case "42":
                returnStr = "\r\n42 - ";
                break;
            case "43":
                returnStr = "\r\n43 - ";
                break;
            case "44":
                returnStr = "\r\n44 - ";
                break;
            case "45":
                returnStr = "\r\n45 - ";
                break;

            default:
                break;
        }
        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string for POQD
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPOQDQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n8 - ";
                break;
            case "9":
                returnStr = "\r\n9 - ";
                break;
            case "10":
                returnStr = "\r\n10 - ";
                break;
            case "11":
                returnStr = "\r\n11 -";
                break;
            case "12":
                returnStr = "\r\n12 - ";
                break;
            case "13":
                returnStr = "\r\n13 - ";
                break;
            case "14":
                returnStr = "\r\n14 - ";
                break;
            case "15":
                returnStr = "\r\n15 - ";
                break;
            case "16":
                returnStr = "\r\n16 - ";
                break;
            case "17":
                returnStr = "\r\n17 - ";
                break;
            case "18":
                returnStr = "\r\n18 - ";
                break;
            case "19":
                returnStr = "\r\n19 - ";
                break;
            case "20":
                returnStr = "\r\n20 - ";
                break;
            case "21":
                returnStr = "\r\n21 - ";
                break;
            case "22":
                returnStr = "\r\n22 - ";
                break;
            case "23":
                returnStr = "\r\n23 - ";
                break;
            case "24":
                returnStr = "\r\n24 - ";
                break;
            case "25":
                returnStr = "\r\n25 - ";
                break;
            case "26":
                returnStr = "\r\n26 - ";
                break;
            case "27":
                returnStr = "\r\n27 - ";
                break;
            case "28":
                returnStr = "\r\n28 - ";
                break;

            default:
                break;
        }
        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string for POQF
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPOQFQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n8 - ";
                break;
            case "9":
                returnStr = "\r\n9 - ";
                break;
            case "10":
                returnStr = "\r\n10 - ";
                break;
            case "11":
                returnStr = "\r\n11 -";
                break;
            case "12":
                returnStr = "\r\n12 - ";
                break;
            case "13":
                returnStr = "\r\n13 - ";
                break;
            case "14":
                returnStr = "\r\n14 - ";
                break;
            case "15":
                returnStr = "\r\n15 - ";
                break;
            case "16":
                returnStr = "\r\n16 - ";
                break;
            case "17":
                returnStr = "\r\n17 - ";
                break;
            case "18":
                returnStr = "\r\n18 - ";
                break;
            case "19":
                returnStr = "\r\n19 - ";
                break;
            case "20":
                returnStr = "\r\n20 - ";
                break;
            case "21":
                returnStr = "\r\n21 - ";
                break;
            case "22":
                returnStr = "\r\n22 - ";
                break;
            case "23":
                returnStr = "\r\n23 - ";
                break;
            case "24":
                returnStr = "\r\n24 - ";
                break;
            case "25":
                returnStr = "\r\n25 - ";
                break;
            case "26":
                returnStr = "\r\n26 - ";
                break;
            case "27":
                returnStr = "\r\n27 - ";
                break;
            case "28":
                returnStr = "\r\n28 - ";
                break;
            case "29":
                returnStr = "\r\n29 - ";
                break;
            case "30":
                returnStr = "\r\n30 - ";
                break;
            case "31":
                returnStr = "\r\n31 - ";
                break;
            case "32":
                returnStr = "\r\n32 - ";
                break;
            case "33":
                returnStr = "\r\n33 - ";
                break;
            case "34":
                returnStr = "\r\n34 - ";
                break;
            case "35":
                returnStr = "\r\n35 - ";
                break;
            case "36":
                returnStr = "\r\n36 - ";
                break;

            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for WHODAS-I
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getWHODASIQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "F1":
                returnStr = "\r\nF1 - ";
                break;
            case "F2":
                returnStr = "\r\nF2 - ";
                break;
            case "F3":
                returnStr = "\r\nF3 - ";
                break;
            case "F4":
                returnStr = "\r\nF4 - ";
                break;
            case "F5":
                returnStr = "\r\nF5 - ";
                break;
            case "A1":
                returnStr = "\r\nA1 - ";
                break;
            case "A2":
                returnStr = "\r\nA2 - ";
                break;
            case "A3":
                returnStr = "\r\nA3 - ";
                break;
            case "A4":
                returnStr = "\r\nA4 - ";
                break;
            case "A5":
                returnStr = "\r\nA5 - ";
                break;
            case "S1":
                returnStr = "\r\nS1 - ";
                break;
            case "S2":
                returnStr = "\r\nS2 - ";
                break;
            case "S3":
                returnStr = "\r\nS3 - ";
                break;
            case "S4":
                returnStr = "\r\nS4 - ";
                break;
            case "S5":
                returnStr = "\r\nS5 - ";
                break;
            case "S6":
                returnStr = "\r\nS6 - ";
                break;
            case "S7":
                returnStr = "\r\nS7 - ";
                break;
            case "S8":
                returnStr = "\r\nS8 - ";
                break;
            case "S9":
                returnStr = "\r\nS9 - ";
                break;
            case "S10":
                returnStr = "\r\nS10 - ";
                break;
            case "S11":
                returnStr = "\r\nS11 -";
                break;
            case "S12":
                returnStr = "\r\nS12 - ";
                break;
            case "H1":
                returnStr = "\r\nH1 - ";
                break;
            case "H2":
                returnStr = "\r\nH2 - ";
                break;
            case "H3":
                returnStr = "\r\nH3 - ";
                break;
            case "S5Score":
                returnStr = "\r\n";
                break;
            case "S11Score":
                returnStr = "\r\n";
                break;
            case "S12Score":
                returnStr = "\r\n";
                break;

            default:
                break;
        }
        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string for WHODAS-P
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getWHODASPQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "H4":
                returnStr = "H4 - ";
                break;
            case "S1":
                returnStr = "S1 - ";
                break;
            case "S2":
                returnStr = "S2 - ";
                break;
            case "S3":
                returnStr = "S3 - ";
                break;
            case "S4":
                returnStr = "S4 - ";
                break;
            case "S5":
                returnStr = "S5 - ";
                break;
            case "S6":
                returnStr = "S6 - ";
                break;
            case "S7":
                returnStr = "S7 - ";
                break;
            case "S8":
                returnStr = "S8 - ";
                break;
            case "S9":
                returnStr = "S9 - ";
                break;
            case "S10":
                returnStr = "S10 - ";
                break;
            case "S11":
                returnStr = "S11 -";
                break;
            case "S12":
                returnStr = "S12 - ";
                break;
            case "H1":
                returnStr = "H1 - ";
                break;
            case "H2":
                returnStr = "H2 - ";
                break;
            case "H3":
                returnStr = "H3 - ";
                break;

            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for WHODAS-S
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getWHODASSQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "S1":
                returnStr = "S1 - ";
                break;
            case "S2":
                returnStr = "S2 - ";
                break;
            case "S3":
                returnStr = "S3 - ";
                break;
            case "S4":
                returnStr = "S4 - ";
                break;
            case "S5":
                returnStr = "S5 - ";
                break;
            case "S6":
                returnStr = "S6 - ";
                break;
            case "S7":
                returnStr = "S7 - ";
                break;
            case "S8":
                returnStr = "S8 - ";
                break;
            case "S9":
                returnStr = "S9 - ";
                break;
            case "S10":
                returnStr = "S10 - ";
                break;
            case "S11":
                returnStr = "S11 -";
                break;
            case "S12":
                returnStr = "S12 - ";
                break;
            case "H1":
                returnStr = "H1 - ";
                break;
            case "H2":
                returnStr = "H2 - ";
                break;
            case "H3":
                returnStr = "H3 - ";
                break;

            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for SRS
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getSRSQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for GAD-7
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getGAD7QuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n";
                break;
            default:
                break;
        }
        return returnStr;
    }


    /// <summary>
    /// Method takes question number from database and transforms to requested display string for Timed Up And Go
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getTimedUpAndGoQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n";
                break;
            case "9":
                returnStr = "\r\n";
                break;
            default:
                break;
        }
        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getFunctionalMobilityQuestionName(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "";
                break;
            case "2":
                returnStr = "Question 1";
                break;
            case "2Comment":
                returnStr = "Question 1 Comment";
                break;
            case "2R":
                returnStr = "Question 1 Rating Priority";
                break;
            case "3":
                returnStr = "Question 2";
                break;
            case "3Comment":
                returnStr = "Question 2 Comment";
                break;
            case "3R":
                returnStr = "Question 2 Rating Priority";
                break;
            case "4":
                returnStr = "Question 3";
                break;
            case "4Comment":
                returnStr = "Question 3 Comment";
                break;
            case "4R":
                returnStr = "Question 3 Rating Priority";
                break;
            case "5":
                returnStr = "Question 4";
                break;
            case "5Comment":
                returnStr = "Question 4 Comment";
                break;
            case "5R":
                returnStr = "Question 4 Rating Priority";
                break;
            case "6":
                returnStr = "Question 5";
                break;
            case "6Comment":
                returnStr = "Question 5 Comment";
                break;
            case "6R":
                returnStr = "Question 5 Rating Priority";
                break;
            case "7":
                returnStr = "Question 6";
                break;
            case "7Comment":
                returnStr = "Question 6 Comment";
                break;
            case "7R":
                returnStr = "Question 6 Rating Priority";
                break;
            case "8":
                returnStr = "Question 7";
                break;
            case "8Comment":
                returnStr = "Question 7 Comment";
                break;
            case "8R":
                returnStr = "Question 7 Rating Priority";
                break;
            case "9":
                returnStr = "Question 8";
                break;
            case "9Comment":
                returnStr = "Question 8 Comment";
                break;
            case "9R":
                returnStr = "Question 8 Rating Priority";
                break;
            case "10":
                returnStr = "Question 9";
                break;
            case "10Comment":
                returnStr = "Question 9 Comment";
                break;
            case "10R":
                returnStr = "Question 9 Rating Priority";
                break;
            case "11":
                returnStr = "Question 10";
                break;
            case "11Comment":
                returnStr = "Question 10 Comment";
                break;
            case "11R":
                returnStr = "Question 10 Rating Priority";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getTwoMinWalkTestTrialName(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "Assistive Device and/or Brace Used";
                break;
            case "2":
                returnStr = "Trial 1 Date";
                break;
            case "3":
                returnStr = "Trial 1 Distance";
                break;
            case "4":
                returnStr = "Trial 2 Date";
                break;
            case "5":
                returnStr = "Trial 2 Distance";
                break;
            case "6":
                returnStr = "Trial 3 Date";
                break;
            case "7":
                returnStr = "Trial 3 Distance";
                break;
            case "8":
                returnStr = "Trial 4 Date";
                break;
            case "9":
                returnStr = "Trial 4 Distance";
                break;
            case "10":
                returnStr = "Average Distance";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Utility method to return formatted Question Number for QUEST
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getQUESTNoteQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "TechDev":
                returnStr = "";
                break;
            case "D":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "1Comment":
                returnStr = "Question 1 ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "2Comment":
                returnStr = "Question 2 ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "3Comment":
                returnStr = "Question 3 ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "4Comment":
                returnStr = "Question 4 ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "5Comment":
                returnStr = "Question 5 ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "6Comment":
                returnStr = "Question 6 ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "7Comment":
                returnStr = "Question 7 ";
                break;
            case "8":
                returnStr = "8 - ";
                break;
            case "8Comment":
                returnStr = "Question 8 ";
                break;
            case "9":
                returnStr = "9 - ";
                break;
            case "9Comment":
                returnStr = "Question 9 ";
                break;
            case "10":
                returnStr = "10 - ";
                break;
            case "10Comment":
                returnStr = "Question 10 ";
                break;
            case "11":
                returnStr = "11 - ";
                break;
            case "11Comment":
                returnStr = "Question 11 ";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "12Comment":
                returnStr = "Question 12 ";
                break;
            case "13":
            case "14":
                returnStr = "";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            case "16":
                returnStr = "";
                break;
            case "17":
                returnStr = "";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getLCIQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "\r\nBasic Activities\r\n1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "\r\nAdvanced Activities\r\n1 - ";
                break;
            case "9":
                returnStr = "2 - ";
                break;
            case "10":
                returnStr = "3 - ";
                break;
            case "11":
                returnStr = "4 - ";
                break;
            case "12":
                returnStr = "5 - ";
                break;
            case "12Comment":
                returnStr = "Question 12 ";
                break;
            case "13":
                returnStr = "6 - ";
                break;
            case "14":
                returnStr = "7 - ";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            case "16":
                returnStr = "";
                break;
            case "17":
                returnStr = "";
                break;
            default:
                break;
        }

        return returnStr;
    }

        /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getCTBIEQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "14": returnStr = "13. "; break;
            case "15": returnStr = "14. "; break;
            case "16": returnStr = "15. "; break;
            case "16-A": returnStr = "15-A. "; break;
            case "16-B": returnStr = "15-B. "; break;
            case "16-C": returnStr = "15-C. "; break;
            case "16-D": returnStr = "15-D. "; break;
            case "16-E": returnStr = "15-E. "; break;
            case "16-F": returnStr = "15-F. "; break;
            case "16-G": returnStr = "15-G. "; break;
            case "16-H": returnStr = "15-H. "; break;
            case "16-I": returnStr = "15-I. "; break;
            case "16-J": returnStr = "15-J. "; break;
            case "16-K": returnStr = "15-K. "; break;
            case "16-L": returnStr = "15-L. "; break;
            case "16-M": returnStr = "15-M. "; break;
            case "16-N": returnStr = "15-N. "; break;
            case "16-O": returnStr = "15-O. "; break;
            case "16-P": returnStr = "15-P. "; break;
            case "16-Q": returnStr = "15-Q. "; break;
            case "16-R": returnStr = "15-R. "; break;
            case "16-S": returnStr = "15-S. "; break;
            case "16-T": returnStr = "15-T. "; break;
            case "16-U": returnStr = "15-U. "; break;
            case "16-V": returnStr = "15-V. "; break;
            case "18": returnStr = "16. "; break;
            case "18-A": returnStr = "16-A. "; break;
            case "18-B": returnStr = "16-B. "; break;
            case "18-C": returnStr = "16-C. "; break;
            case "19": returnStr = "17. "; break;
            case "20": returnStr = "18. "; break;
            case "21": returnStr = "19. "; break;
            case "21-A": returnStr = "19-A. "; break;
            case "21-B": returnStr = "19-B. "; break;
            case "21-C": returnStr = "19-C. "; break;
            case "22": returnStr = "20. "; break;
            case "27": returnStr = "21. "; break;
            case "28": returnStr = "22. "; break;
            case "28-A": returnStr = "22-A. "; break;
            case "29": returnStr = "23. "; break;
            case "29-A": returnStr = "23-A. "; break;
            case "29-A-1": returnStr = "23-A-1. "; break;
            case "29-A-1-a": returnStr = "23-A-1-a. "; break;
            case "29-A-1-b": returnStr = "23-A-1-b. "; break;
            case "29-A-1-c": returnStr = "23-A-1-c. "; break;
            case "29-A-1-d": returnStr = "23-A-1-d. "; break;
            case "29-A-1-e": returnStr = "23-A-1-e. "; break;
            case "29-A-1-e-1": returnStr = "23-A-1-e-1. "; break;
            case "29-A-1-f": returnStr = "23-A-1-f. "; break;
            case "29-A-1-f-1": returnStr = "23-A-1-f-1. "; break;
            case "29-A-1-f-2": returnStr = "23-A-1-f-2. "; break;
            case "29-A-1-g": returnStr = "23-A-1-g. "; break;
            case "29-A-1-h": returnStr = "23-A-1-h. "; break;
            case "29-A-1-i": returnStr = "23-A-1-i. "; break;
            case "29-A-1-j": returnStr = "23-A-1-j. "; break;
            case "29-A-1-j-1": returnStr = "23-A-1-j-1. "; break;
            case "29-A-2": returnStr = "23-A-2. "; break;
            case "29-A-2-a": returnStr = "23-A-2-1. "; break;
            case "30": returnStr = "24. "; break;
            case "31": returnStr = "24. "; break;
            default:
                returnStr = questionNumber+". ";
                break;
        }

        return returnStr;

        }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getVALowVisionQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "";
                break;
            case "TYP":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n";
                break;
            // For question numbers 2 - 21 the actual question number on the survey screen is one less
            case "2":
                returnStr = "\r\n1 - ";
                break;
            case "3":
            case "4":
            case "5":
            case "6":
            case "7":
            case "8":
            case "9":
            case "10":
            case "11":
            case "12":
            case "13":
            case "14":
            case "15":
            case "16":
            case "17":
            case "18":
            case "19":
            case "20":
            case "21":
                questionNumber = Convert.ToString(Convert.ToInt32(questionNumber) - 1);
                returnStr = questionNumber + " - ";
                break;
            case "22":
                returnStr = "\r\n";
                break;
            case "23":
                returnStr = "\r\n";
                break;
            case "24":
                returnStr = "\r\n";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getBergBalanceQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "DX":
                returnStr = "\r\n";
                break;
            case "D":
                returnStr = "\r\n";
                break;
            case "TYP":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "\r\n2 - ";
                break;
            case "3":
                returnStr = "\r\n3 - ";
                break;
            case "4":
                returnStr = "\r\n4 - ";
                break;
            case "5":
                returnStr = "\r\n5 - ";
                break;
            case "6":
                returnStr = "\r\n6 - ";
                break;
            case "7":
                returnStr = "\r\n7 - ";
                break;
            case "8":
                returnStr = "\r\n8 - ";
                break;
            case "9":
                returnStr = "\r\n9 - ";
                break;
            case "10":
                returnStr = "\r\n10 - ";
                break;
            case "11":
                returnStr = "\r\n11 - ";
                break;
            case "12":
                returnStr = "\r\n12 - ";
                break;
            case "13":
                returnStr = "\r\n13 - ";
                break;
            case "14":
                returnStr = "\r\n14 - ";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getDisabilityRatingScaleQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "DTE":
                returnStr = "";
                break;
            case "TYP":
                returnStr = "";
                break;
            case "17":
                returnStr = "16 - ";
                break;
            case "18":
                returnStr = "17 - ";
                break;
            case "19":
                returnStr = "18 - ";
                break;
            case "20":
                returnStr = "19 - ";
                break;
            case "21":
                returnStr = "20 - ";
                break;
            case "22":
                returnStr = "\r\n";
                break;
            case "23":
                returnStr = "";
                break;
            case "24":
                returnStr = "";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getSatisfactionWithLifeScaleQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "D":
                returnStr = "";
                break;
            case "DX":
                returnStr = "\r\n";
                break;
            case "1":
                returnStr = "\r\n1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "8 - ";
                break;
            case "9":
                returnStr = "9 - ";
                break;
            case "10":
                returnStr = "10 - ";
                break;
            case "11":
                returnStr = "11 - ";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "13":
                returnStr = "13 - ";
                break;
            case "14":
                returnStr = "14 - ";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getPART_OQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "8 - ";
                break;
            case "9":
                returnStr = "9 - ";
                break;
            case "10":
                returnStr = "10 - ";
                break;
            case "11":
                returnStr = "11 - ";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "13":
                returnStr = "13 - ";
                break;
            case "14":
                returnStr = "14 - ";
                break;
            case "15":
                returnStr = "15 - ";
                break;
            case "16":
                returnStr = "16 - ";
                break;
            case "17":
                returnStr = "17 - ";
                break;
            case "18":
            case "19":
            case "20":
            case "21":
            case "22":
            case "23":
                returnStr = "";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getOptimalQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "\r\nBasic Activities\r\n1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "\r\nAdvanced Activities\r\n1 - ";
                break;
            case "9":
                returnStr = "2 - ";
                break;
            case "10":
                returnStr = "3 - ";
                break;
            case "11":
                returnStr = "4 - ";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "12Comment":
                returnStr = "Question 12 ";
                break;
            case "13":
            case "14":
                returnStr = "";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            case "16":
                returnStr = "";
                break;
            case "17":
                returnStr = "";
                break;
            case "Baseline Difficulty-23a":
                returnStr = "";
                break;
            case "Baseline Difficulty-23b":
                returnStr = "";
                break;
            case "Baseline Difficulty-23c":
                returnStr = "";
                break;
            case "Baseline Difficulty-24":
                returnStr = "";
                break;
            default:
                break;
        }

        return returnStr;
    }

    /// <summary>
    /// Method takes question number from database and transforms to requested display string.
    /// </summary>
    /// <param name="questionNumber"></param>
    /// <returns></returns>
    private string getRehabFollowUpQuestionNumber(string questionNumber)
    {
        string returnStr = "";

        switch (questionNumber)
        {
            case "1":
                returnStr = "1 - ";
                break;
            case "2":
                returnStr = "2 - ";
                break;
            case "3":
                returnStr = "3 - ";
                break;
            case "4":
                returnStr = "4 - ";
                break;
            case "5":
                returnStr = "5 - ";
                break;
            case "6":
                returnStr = "6 - ";
                break;
            case "7":
                returnStr = "7 - ";
                break;
            case "8":
                returnStr = "1 - ";
                break;
            case "9":
                returnStr = "2 - ";
                break;
            case "10":
                returnStr = "3 - ";
                break;
            case "11":
                returnStr = "4 - ";
                break;
            case "12":
                returnStr = "12 - ";
                break;
            case "12Comment":
                returnStr = "Question 12 ";
                break;
            case "13":
            case "14":
                returnStr = "";
                break;
            case "15":
                returnStr = "\r\n";
                break;
            case "16":
                returnStr = "";
                break;
            case "17":
                returnStr = "";
                break;
            default:
                break;
        }

        return returnStr;
    }



    /// <summary>
    /// removes <br /> from the beginning of a string.
    /// </summary>
    /// <param name="value"></param>
    /// <returns></returns>
    private string removePrecedingLineBreaks(string value)
    {
        while (value.StartsWith("<br />"))
        {
            value = value.Substring(6);
        }

        return value;
    }

    #endregion

    #endregion
}